/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.versionchecker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.pentaho.versionchecker.IVersionCheckDataProvider;
import org.pentaho.versionchecker.IVersionCheckErrorHandler;
import org.pentaho.versionchecker.IVersionCheckResultHandler;
import org.pentaho.versionchecker.UUIDUtil;
import org.pentaho.versionchecker.VersionCheckResourceBundle;

public class VersionChecker {
    private static final String PENTAHO_DIR = ".pentaho";
    private static final String VERCHECK_PROPS_FILENAME = ".vercheck";
    public static final String VERCHECK_CANT_SAVE_GUID = "12345-67890-09876-54321";
    public static final boolean DEBUGGING = false;
    private static final String PROP_ROOT = "versionchk";
    private static final String PROP_SYSTEM_GUID = "versionchk.guid";
    private static final String PROP_UPDATE = "update";
    private static final String PROP_LASTCHECK = "lastcheck";
    private static boolean isWritable = true;
    private static File propsDirectory;
    private static File propsFile;
    private static Properties props;
    private static String guid;
    protected IVersionCheckDataProvider dataProvider;
    protected final Set resultHandlers = new HashSet();
    protected final Set errorHandlers = new HashSet();
    private static final String DEFAULT_URL;
    private static final String DEFAULT_TIMEOUT_MILLIS;
    private HttpClient defaultHttpClient;
    private HttpMethod defaultHttpMethod;

    public static void init() {
        try {
            isWritable = true;
            propsDirectory = null;
            propsFile = null;
            guid = null;
            props = new Properties();
            String homeDir = VersionChecker.getHomeDir();
            if (homeDir == null) {
                isWritable = false;
            } else {
                propsDirectory = new File(homeDir + (homeDir.endsWith("/") ? "" : File.separator) + PENTAHO_DIR);
                propsDirectory.mkdirs();
                String propsPath = propsDirectory.getCanonicalPath();
                propsFile = new File(propsPath + (propsPath.endsWith("/") ? "" : File.separator) + VERCHECK_PROPS_FILENAME);
            }
        }
        catch (Throwable th) {
            isWritable = false;
        }
        VersionChecker.loadProperties();
        VersionChecker.LoadOrGenerateGuid();
    }

    public static boolean getIsWritable() {
        return isWritable;
    }

    public static String getPropertiesDirectory() throws IOException {
        return propsDirectory != null ? propsDirectory.getCanonicalPath() : null;
    }

    private static void LoadOrGenerateGuid() {
        guid = props.getProperty(PROP_SYSTEM_GUID);
        if (guid == null) {
            VersionChecker.generateGUID();
            props.setProperty(PROP_SYSTEM_GUID, guid);
            VersionChecker.saveProperties();
        }
    }

    private static void generateGUID() {
        guid = isWritable ? UUIDUtil.getUUIDAsString() : VERCHECK_CANT_SAVE_GUID;
    }

    private static boolean testWritabilityOfFolder(String testName) {
        boolean rtn = false;
        if (testName != null && testName.length() > 0) {
            String test1 = testName + (testName.endsWith("/") ? "" : File.separator) + "test_pentaho_write_.txt";
            File testThisDir = new File(test1);
            try {
                if (!testThisDir.exists()) {
                    testThisDir.createNewFile();
                }
                rtn = true;
                testThisDir.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rtn;
    }

    private static String getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (!(homeDir != null && homeDir.length() != 0 && VersionChecker.testWritabilityOfFolder(homeDir) || VersionChecker.testWritabilityOfFolder(homeDir = ".") || VersionChecker.testWritabilityOfFolder(homeDir = System.getProperty("java.io.tmpdir")))) {
            homeDir = null;
        }
        return homeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        if (isWritable) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propsFile);
                props.clear();
                props.load(fis);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    public static String getGuid() {
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties() {
        if (isWritable) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(propsFile);
                props.store(fos, "Pentaho Version Checker Properties");
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public VersionChecker() {
    }

    public void setDataProvider(IVersionCheckDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void addResultHandler(IVersionCheckResultHandler resultHandler) {
        if (resultHandler != null) {
            this.resultHandlers.add(resultHandler);
        }
    }

    public void removeResultHandler(IVersionCheckResultHandler resultHandler) {
        this.resultHandlers.remove(resultHandler);
    }

    public void addErrorHandler(IVersionCheckErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.errorHandlers.add(errorHandler);
        }
    }

    public void removeErrorHandler(IVersionCheckErrorHandler errorHandler) {
        this.errorHandlers.remove(errorHandler);
    }

    public void performCheck(boolean ignoreExistingUpdates) {
        HttpClient httpClient = this.getHttpClient();
        HttpMethod httpMethod = this.getHttpMethod();
        try {
            int timeout = 30000;
            try {
                timeout = Integer.parseInt(DEFAULT_TIMEOUT_MILLIS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
            this.setURL(httpMethod, guid);
            int resultCode = httpClient.executeMethod(httpMethod);
            if (resultCode != 200) {
                throw new Exception("Invalid Result Code Returned: " + resultCode);
            }
            String resultXml = httpMethod.getResponseBodyAsString();
            resultXml = VersionChecker.checkForUpdates(this.dataProvider, resultXml, props, ignoreExistingUpdates);
            this.processResults(resultXml);
            if (this.dataProvider != null) {
                String lastCheckProp = "versionchk." + this.dataProvider.getApplicationID() + "." + this.dataProvider.getApplicationVersion() + "." + PROP_LASTCHECK;
                props.setProperty(lastCheckProp, new Date().toString());
                VersionChecker.saveProperties();
            }
            httpMethod.releaseConnection();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    static String checkForUpdates(IVersionCheckDataProvider dataProvider, String resultXml, Properties propsToCheck, boolean ignoreExistingUpdates) {
        int updateLoc;
        if (dataProvider != null && (updateLoc = resultXml.indexOf("<update")) >= 0) {
            boolean found = true;
            while (updateLoc >= 0) {
                int versionLocBegin = resultXml.indexOf(" version=\"", updateLoc);
                int versionLocEnd = resultXml.indexOf("\"", versionLocBegin + 10);
                String version = resultXml.substring(versionLocBegin + 10, versionLocEnd);
                int typeLocBegin = resultXml.indexOf(" type=\"", updateLoc);
                int typeLocEnd = resultXml.indexOf("\"", typeLocBegin + 7);
                String type = resultXml.substring(typeLocBegin + 7, typeLocEnd);
                int titleLocBegin = resultXml.indexOf(" title=\"", updateLoc);
                int titleLocEnd = resultXml.indexOf("\"", titleLocBegin + 8);
                String title = resultXml.substring(titleLocBegin + 8, titleLocEnd);
                String versionAndType = title + " " + version + " " + type;
                String updateProp = "versionchk." + dataProvider.getApplicationID() + "." + dataProvider.getApplicationVersion() + "." + PROP_UPDATE;
                String updateVal = propsToCheck.getProperty(updateProp, "");
                if (updateVal.indexOf(versionAndType) < 0) {
                    if (updateVal.length() > 0) {
                        updateVal = updateVal + ",";
                    }
                    updateVal = updateVal + versionAndType;
                    propsToCheck.setProperty(updateProp, updateVal);
                    found = false;
                }
                updateLoc = resultXml.indexOf("<update", updateLoc + 1);
            }
            if (found && ignoreExistingUpdates) {
                return "<vercheck protocol=\"1.0\"/>";
            }
        }
        return resultXml;
    }

    protected void setURL(HttpMethod method, String guid) throws URIException {
        String urlBase = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.dataProvider != null) {
            urlBase = this.dataProvider.getBaseURL();
            Map params = this.dataProvider.getExtraInformation();
            if (params != null && params.size() > 0) {
                parameters.putAll(params);
            }
            String productID = this.dataProvider.getApplicationID();
            String version = this.dataProvider.getApplicationVersion();
            int depth = this.dataProvider.getDepth();
            String vi = VersionChecker.computeVI(productID);
            parameters.put("depth", "" + depth);
            parameters.put("prodID", productID);
            parameters.put("version", version);
            parameters.put("guid", guid);
            parameters.put("vi", vi);
        }
        if (urlBase == null) {
            urlBase = this.getDefaultURL();
        }
        String urlCreated = VersionChecker.createURL(urlBase, parameters);
        URI uri = new URI(urlCreated, true);
        method.setURI(uri);
    }

    protected String getDefaultURL() {
        return DEFAULT_URL;
    }

    protected static String createURL(String urlBase, Map parameters) {
        StringBuffer queryString = new StringBuffer();
        queryString.append(urlBase);
        if (parameters != null) {
            String connector = "";
            if (urlBase.indexOf(63) == -1) {
                connector = "?";
            } else if (!urlBase.endsWith("&")) {
                connector = "&";
            }
            for (Object key : parameters.keySet()) {
                if (key == null) continue;
                Object obj = parameters.get(key);
                String value = obj != null ? obj.toString() : "";
                queryString.append(connector).append(URLEncoder.encode(key.toString())).append('=').append(URLEncoder.encode(value));
                connector = "&";
            }
        }
        return queryString.toString();
    }

    protected static final String computeVI(String productID) {
        return DigestUtils.md5Hex((String)((productID == null ? "" : productID) + (guid == null ? "" : guid)));
    }

    protected void processResults(String results) {
        Iterator it = this.resultHandlers.iterator();
        while (it.hasNext()) {
            try {
                IVersionCheckResultHandler resultHandler = (IVersionCheckResultHandler)it.next();
                resultHandler.processResults(results);
            }
            catch (Throwable t) {
                System.err.println(VersionCheckResourceBundle.getString("VersionChecker.ERROR_0001_ERROR_THROWN_FROM_RESULTS_HANDLER"));
            }
        }
    }

    protected void handleException(Exception e) {
        Iterator it = this.errorHandlers.iterator();
        while (it.hasNext()) {
            try {
                IVersionCheckErrorHandler errorHandler = (IVersionCheckErrorHandler)it.next();
                errorHandler.handleException(e);
            }
            catch (Throwable t) {
                System.err.println(VersionCheckResourceBundle.getString("VersionChecker.ERROR_0001_ERROR_THROWN_FROM_ERROR_HANDLER"));
            }
        }
    }

    protected HttpClient getHttpClient() {
        return this.defaultHttpClient != null ? this.defaultHttpClient : new HttpClient();
    }

    protected HttpMethod getHttpMethod() {
        return this.defaultHttpMethod != null ? this.defaultHttpMethod : new GetMethod();
    }

    protected VersionChecker(HttpClient defaultHttpClient, HttpMethod defaultHttpMethod) {
        this();
        this.setDefaultHttpClient(defaultHttpClient);
        this.setDefaultHttpMethod(defaultHttpMethod);
    }

    protected void setDefaultHttpClient(HttpClient httpClient) {
        this.defaultHttpClient = httpClient;
    }

    protected void setDefaultHttpMethod(HttpMethod httpMethod) {
        this.defaultHttpMethod = httpMethod;
    }

    static {
        VersionChecker.init();
        DEFAULT_URL = VersionCheckResourceBundle.getString("VersionChecker.CODE_default_url");
        DEFAULT_TIMEOUT_MILLIS = VersionCheckResourceBundle.getString("VersionChecker.CODE_default_timeout_millis");
    }
}

