/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsUtils;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class ContainerLogsPage
extends NMView {
    public static final String REDIRECT_URL = "redirect.url";

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        String redirectUrl = this.$(REDIRECT_URL);
        if (redirectUrl == null || redirectUrl.isEmpty()) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Logs for ", this.$("container.id")}));
        } else if (redirectUrl.equals("false")) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Failed redirect for ", this.$("container.id")}));
        } else {
            this.set("title", StringHelper.join((Object[])new Object[]{"Redirecting to log server for ", this.$("container.id")}));
            html.meta_http("refresh", "1; url=" + redirectUrl);
        }
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return ContainersLogsBlock.class;
    }

    public static class ContainersLogsBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public ContainersLogsBlock(Context context) {
            this.nmContext = context;
        }

        protected void render(HtmlBlock.Block html) {
            ContainerId containerId;
            String redirectUrl = this.$(ContainerLogsPage.REDIRECT_URL);
            if (redirectUrl != null && redirectUrl.equals("false")) {
                html.h1("Failed while trying to construct the redirect url to the log server. Log Server url may not be configured");
            }
            try {
                containerId = ConverterUtils.toContainerId((String)this.$("container.id"));
            }
            catch (IllegalArgumentException ex) {
                html.h1("Invalid container ID: " + this.$("container.id"));
                return;
            }
            try {
                if (this.$("log.type").isEmpty()) {
                    List<File> logFiles = ContainerLogsUtils.getContainerLogDirs(containerId, this.request().getRemoteUser(), this.nmContext);
                    this.printLogFileDirectory(html, logFiles);
                } else {
                    File logFile = ContainerLogsUtils.getContainerLogFile(containerId, this.$("log.type"), this.request().getRemoteUser(), this.nmContext);
                    this.printLogFile(html, logFile);
                }
            }
            catch (YarnException ex) {
                html.h1(ex.getMessage());
            }
            catch (NotFoundException ex) {
                html.h1(ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printLogFile(HtmlBlock.Block html, File logFile) {
            long start = this.$("start").isEmpty() ? -4096L : Long.parseLong(this.$("start"));
            start = start < 0L ? logFile.length() + start : start;
            start = start < 0L ? 0L : start;
            long end = this.$("end").isEmpty() ? logFile.length() : Long.parseLong(this.$("end"));
            end = end < 0L ? logFile.length() + end : end;
            long l = end = end < 0L ? logFile.length() : end;
            if (start > end) {
                html.h1("Invalid start and end values. Start: [" + start + "]" + ", end[" + end + "]");
                return;
            }
            FileInputStream logByteStream = null;
            try {
                logByteStream = ContainerLogsUtils.openLogFileForRead(this.$("container.id"), logFile, this.nmContext);
            }
            catch (IOException ex) {
                html.h1(ex.getMessage());
                return;
            }
            try {
                long toRead = end - start;
                if (toRead < logFile.length()) {
                    html.p()._(new Object[]{"Showing " + toRead + " bytes. Click "}).a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), logFile.getName(), "?start=0"}), "here")._(new Object[]{" for full log"})._();
                }
                IOUtils.skipFully((InputStream)logByteStream, (long)start);
                InputStreamReader reader = new InputStreamReader((InputStream)logByteStream, Charset.forName("UTF-8"));
                int bufferSize = 65536;
                char[] cbuf = new char[bufferSize];
                int len = 0;
                int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
                Hamlet.PRE pre = html.pre();
                while ((len = reader.read(cbuf, 0, currentToRead)) > 0 && toRead > 0L) {
                    pre._(new Object[]{new String(cbuf, 0, len)});
                    currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
                }
                pre._();
                reader.close();
            }
            catch (IOException e) {
                LOG.error("Exception reading log file " + logFile.getAbsolutePath(), (Throwable)e);
                html.h1("Exception reading log file. It might be because log file was aggregated : " + logFile.getName());
            }
            finally {
                if (logByteStream != null) {
                    try {
                        logByteStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private void printLogFileDirectory(HtmlBlock.Block html, List<File> containerLogsDirs) {
            Collections.sort(containerLogsDirs);
            boolean foundLogFile = false;
            for (File containerLogsDir : containerLogsDirs) {
                Object[] logFiles = containerLogsDir.listFiles();
                if (logFiles == null) continue;
                Arrays.sort(logFiles);
                for (Object logFile : logFiles) {
                    foundLogFile = true;
                    html.p().a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), ((File)logFile).getName(), "?start=-4096"}), ((File)logFile).getName() + " : Total file length is " + ((File)logFile).length() + " bytes.")._();
                }
            }
            if (!foundLogFile) {
                html.h1("No logs available for container " + this.$("container.id"));
                return;
            }
        }
    }
}

