/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.metaverse.api.model.BaseDatabaseResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class JdbcResourceInfo
extends BaseDatabaseResourceInfo
implements IExternalResourceInfo {
    public static final String JDBC = "JDBC";
    public static final String JSON_PROPERTY_PORT = "port";
    public static final String JSON_PROPERTY_SERVER = "server";
    public static final String JSON_PROPERTY_USERNAME = "username";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    public static final String JSON_PROPERTY_DATABASE_NAME = "databaseName";
    private Integer port;
    private String server;
    private String username;
    private String password;
    private String databaseName;

    @Override
    public String getType() {
        return JDBC;
    }

    public JdbcResourceInfo() {
    }

    public JdbcResourceInfo(DatabaseMeta databaseMeta) {
        super(databaseMeta);
        if ("Native".equals(databaseMeta.getAccessTypeDesc())) {
            this.setServer(databaseMeta.environmentSubstitute(databaseMeta.getHostname()));
            String portString = databaseMeta.environmentSubstitute(databaseMeta.getDatabasePortNumberString());
            if (portString != null) {
                try {
                    this.setPort(Integer.valueOf(portString));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException("DatabaseMeta is not JDBC, it is " + databaseMeta.getAccessTypeDesc());
        }
        this.setUsername(databaseMeta.environmentSubstitute(databaseMeta.getUsername()));
        this.setPassword(databaseMeta.environmentSubstitute(databaseMeta.getPassword()));
        this.setDatabaseName(databaseMeta.environmentSubstitute(databaseMeta.getDatabaseName()));
    }

    public JdbcResourceInfo(String server, String databaseName, Integer port, String username, String password) {
        this.server = server;
        this.databaseName = databaseName;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty(value="server")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)password);
    }

    @JsonProperty(value="password")
    protected String getEncryptedPassword() {
        return "Encrypted " + Encr.encryptPassword((String)this.password);
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

