/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.xls;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.xls.ExcelExportPlugin;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.FlowExcelOutputProcessor;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ExcelExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ExcelExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final MasterReport report;
    private StatusListener statusListener;

    public ExcelExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("ExcelExportTask(..): Null report parameter not permitted");
        }
        this.fileName = report.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.xls.FileName");
        if (this.fileName == null) {
            throw new ReportProcessingException("ExcelExportTask(): Filename is not defined");
        }
        this.progressDialog = dialog;
        this.report = report;
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.xls.messages.messages", ObjectUtilities.getClassLoader(ExcelExportPlugin.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream out = null;
        File file = null;
        try {
            AbstractReportProcessor reportProcessor;
            file = new File(this.fileName).getCanonicalFile();
            File directory = file.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                logger.warn((Object)"Can't create directories. Hoping and praying now..");
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            ReportStructureValidator validator = new ReportStructureValidator();
            if (!validator.isValidForFastProcessing(this.report)) {
                FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(this.report.getConfiguration(), out, this.report.getResourceManager());
                target.setUseXlsxFormat(false);
                reportProcessor = new FlowReportProcessor(this.report, target);
            } else {
                reportProcessor = new FastExcelExportProcessor(this.report, out, false);
            }
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                this.progressDialog.setVisible(true);
                reportProcessor.addReportProgressListener(this.progressDialog);
            }
            reportProcessor.processReport();
            out.close();
            out = null;
            if (this.progressDialog != null) {
                reportProcessor.removeReportProgressListener(this.progressDialog);
            }
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("ExcelExportTask.USER_TASK_FINISHED"), null);
            }
        }
        catch (ReportInterruptedException re) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.WARNING, this.messages.getString("ExcelExportTask.USER_TASK_ABORTED"), null);
            }
            try {
                out.close();
                out = null;
                if (!file.delete()) {
                    logger.warn((Object)("Unable to delete incomplete export:" + file));
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception re) {
            logger.error((Object)"Excel export failed", (Throwable)re);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.WARNING, this.messages.getString("ExcelExportTask.USER_TASK_FAILED"), re);
            }
        }
        finally {
            block30: {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to close the output stream.", (Throwable)e);
                    if (this.statusListener == null) break block30;
                    this.statusListener.setStatus(StatusType.WARNING, this.messages.getString("ExcelExportTask.USER_TASK_FAILED"), e);
                }
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
    }
}

