/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.dataservice.client.DataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.RemoteClient;
import org.pentaho.di.trans.dataservice.jdbc.ThinBase;
import org.pentaho.di.trans.dataservice.jdbc.ThinDatabaseMetaData;
import org.pentaho.di.trans.dataservice.jdbc.ThinPreparedStatement;
import org.pentaho.di.trans.dataservice.jdbc.ThinStatement;
import org.pentaho.di.trans.dataservice.jdbc.annotation.NotSupported;

public class ThinConnection
extends ThinBase
implements Connection {
    public static final String ARG_WEBAPPNAME = "webappname";
    public static final String ARG_PROXYHOSTNAME = "proxyhostname";
    public static final String ARG_PROXYPORT = "proxyport";
    public static final String ARG_NONPROXYHOSTS = "nonproxyhosts";
    public static final String ARG_DEBUGTRANS = "debugtrans";
    public static final String ARG_DEBUGLOG = "debuglog";
    public static final String ARG_ISSECURE = "secure";
    public static final String ARG_LOCAL = "local";
    public static DataServiceClientService localClient;
    protected DataServiceClientService clientService;
    private final String url;
    private final String hostname;
    private final String port;
    private String username;
    private String password;
    private String webAppName;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private boolean isSecure;
    private String debugTransFilename;
    private boolean debuggingRemoteLog;
    private ImmutableMap<String, String> parameters = ImmutableMap.of();
    private boolean isLocal;

    protected ThinConnection(String url, String hostname, String port) {
        this.url = url;
        this.hostname = hostname;
        this.port = port;
    }

    protected String constructUrl(String serviceAndArguments) throws SQLException {
        try {
            return HttpUtil.constructUrl((VariableSpace)new Variables(), (String)this.hostname, (String)this.port, (String)this.webAppName, (String)("/kettle" + serviceAndArguments), (boolean)this.isSecure);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SQLException.class);
            throw new SQLException(e);
        }
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    @NotSupported
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating BLOBs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating CLOBs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating NCLOBs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating SQL XML is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ThinStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ThinStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ThinStatement(this);
    }

    @Override
    @NotSupported
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Creating structs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    @NotSupported
    public String getClientInfo(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Client Info is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ThinDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean bl;
        Statement statement = this.createStatement();
        try {
            bl = statement.executeQuery("SELECT *").next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception e) {
                this.setWarning(e);
                return false;
            }
        }
        statement.close();
        return bl;
    }

    @Override
    @NotSupported
    public String nativeSQL(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Native SQL statements are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Perpared calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Perpared calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLFeatureNotSupportedException("Perpared calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndex) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    @NotSupported
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public void rollback(Savepoint arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void setAutoCommit(boolean auto) throws SQLException {
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
    }

    @Override
    @NotSupported
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Safepoints calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Safepoints calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    @NotSupported
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPort() {
        return this.port;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String getDebugTransFilename() {
        return this.debugTransFilename;
    }

    public boolean isDebuggingRemoteLog() {
        return this.debuggingRemoteLog;
    }

    ImmutableMap<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    @NotSupported
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Abort Connection not supported");
    }

    @Override
    @NotSupported
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Network Timeout not supported");
    }

    @Override
    @NotSupported
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Network Timeout not supported");
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public static DataServiceClientService getLocalClient() throws SQLException {
        if (localClient == null) {
            throw new SQLException("Local client service is not installed");
        }
        return localClient;
    }

    public DataServiceClientService getClientService() {
        return (DataServiceClientService)Preconditions.checkNotNull((Object)this.clientService, (Object)"Client Service not set for connection");
    }

    private void addCredentials(HttpClient client) {
        AuthScope scope;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        if (Strings.isNullOrEmpty((String)this.webAppName)) {
            scope = new AuthScope(this.hostname, Const.toInt((String)this.port, (int)80), "Kettle");
        } else {
            scope = AuthScope.ANY;
            client.getParams().setAuthenticationPreemptive(true);
        }
        client.getState().setCredentials(scope, (Credentials)credentials);
    }

    private void setProxy(HttpClient client) {
        if (!Const.isEmpty((String)this.proxyHostname) && !Const.isEmpty((String)this.proxyPort)) {
            if (!Const.isEmpty((String)this.nonProxyHosts) && !Const.isEmpty((String)this.hostname) && this.hostname.matches(this.nonProxyHosts)) {
                return;
            }
            client.getHostConfiguration().setProxy(this.proxyHostname, Integer.parseInt(this.proxyPort));
        }
    }

    private ThinConnection extractProperties(Map<String, String> arguments) {
        this.webAppName = arguments.get(ARG_WEBAPPNAME);
        this.proxyHostname = arguments.get(ARG_PROXYHOSTNAME);
        this.proxyPort = arguments.get(ARG_PROXYPORT);
        this.nonProxyHosts = arguments.get(ARG_NONPROXYHOSTS);
        this.debugTransFilename = arguments.get(ARG_DEBUGTRANS);
        this.debuggingRemoteLog = "true".equalsIgnoreCase(arguments.get(ARG_DEBUGLOG));
        this.isSecure = "true".equalsIgnoreCase(arguments.get(ARG_ISSECURE));
        this.isLocal = "true".equalsIgnoreCase(arguments.get(ARG_LOCAL));
        this.parameters = ImmutableMap.copyOf((Map)Maps.filterKeys(arguments, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith("PARAMETER_");
            }
        }));
        this.username = arguments.get("user");
        this.password = arguments.get("password");
        return this;
    }

    public static class Builder {
        private final SlaveConnectionManager connectionManager;
        private final Map<String, String> arguments = Maps.newHashMap();
        private String url;
        private String hostname;
        private String port;

        public Builder(SlaveConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }

        public Builder parseUrl(String url) throws SQLException {
            this.url = url;
            try {
                int portColonIndex = url.indexOf(58, "jdbc:pdi://".length());
                if (portColonIndex < 0) {
                    throw new SQLException("Port is not defined: " + url);
                }
                int kettleIndex = url.indexOf("/kettle", portColonIndex);
                this.hostname = url.substring("jdbc:pdi://".length(), portColonIndex);
                this.port = url.substring(portColonIndex + 1, kettleIndex);
                int startIndex = url.indexOf(63, kettleIndex) + 1;
                if (startIndex > 0) {
                    String path = url.substring(startIndex);
                    Map queryParameters = Splitter.on((char)'&').withKeyValueSeparator('=').split((CharSequence)path);
                    for (Map.Entry parameterEntry : queryParameters.entrySet()) {
                        this.arguments.put(Builder.decode((String)parameterEntry.getKey()), Builder.decode((String)parameterEntry.getValue()));
                    }
                }
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, SQLException.class);
                throw new SQLException("Invalid connection URL: " + url, e);
            }
            return this;
        }

        static String decode(String s) throws UnsupportedEncodingException {
            return URLDecoder.decode(s, Charsets.UTF_8.name());
        }

        public Builder readProperties(Properties properties) {
            this.arguments.putAll((Map<String, String>)Maps.fromProperties((Properties)properties));
            return this;
        }

        private RemoteClient createRemoteClient(ThinConnection connection) {
            HttpClient client = this.connectionManager.createHttpClient();
            connection.addCredentials(client);
            connection.setProxy(client);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(0);
            client.getHttpConnectionManager().getParams().setSoTimeout(0);
            return new RemoteClient(connection, client);
        }

        public ThinConnection build() throws SQLException {
            ThinConnection connection = new ThinConnection(this.url, this.hostname, this.port).extractProperties(this.arguments);
            DataServiceClientService dataServiceClientService = connection.isLocal ? ThinConnection.getLocalClient() : this.createRemoteClient(connection);
            connection.clientService = dataServiceClientService;
            return connection;
        }
    }
}

