/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.CallingContextFactory;
import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.CommandSink;
import de.simplicit.vjdbc.command.CommandSinkListener;
import de.simplicit.vjdbc.command.NullCommandSinkListener;
import de.simplicit.vjdbc.rmi.KeepAliveTimerTask;
import de.simplicit.vjdbc.serial.CallingContext;
import de.simplicit.vjdbc.serial.UIDEx;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class DecoratedCommandSink {
    private UIDEx _connectionUid;
    private CommandSink _targetSink;
    private CommandSinkListener _listener = new NullCommandSinkListener();
    private CallingContextFactory _callingContextFactory;
    private Timer _timer;

    public DecoratedCommandSink(UIDEx connuid, CommandSink sink, CallingContextFactory ctxFactory) {
        this(connuid, sink, ctxFactory, 10000L);
    }

    public DecoratedCommandSink(UIDEx connuid, CommandSink sink, CallingContextFactory ctxFactory, long pingPeriod) {
        this._connectionUid = connuid;
        this._targetSink = sink;
        this._callingContextFactory = ctxFactory;
        if (pingPeriod > 0L) {
            this._timer = new Timer(true);
            KeepAliveTimerTask task = new KeepAliveTimerTask(this);
            this._timer.scheduleAtFixedRate((TimerTask)task, pingPeriod, pingPeriod);
        }
    }

    public CommandSink getTargetSink() {
        return this._targetSink;
    }

    public void close() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
        this._targetSink.close();
    }

    public void setListener(CommandSinkListener listener) {
        this._listener = listener != null ? listener : new NullCommandSinkListener();
    }

    public UIDEx connect(String url, Properties props, Properties clientInfo, CallingContext ctx) throws SQLException {
        return this._targetSink.connect(url, props, clientInfo, ctx);
    }

    public Object process(UIDEx reg, Command cmd) throws SQLException {
        return this.process(reg, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(UIDEx reg, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Object object = this._targetSink.process(this._connectionUid != null ? this._connectionUid.getUID() : null, reg != null ? reg.getUID() : null, cmd, ctx);
            return object;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public int processWithIntResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithIntResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processWithIntResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Integer n = (Integer)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            int n2 = n;
            return n2;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public boolean processWithBooleanResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithBooleanResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processWithBooleanResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Boolean b = (Boolean)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            boolean bl = b;
            return bl;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public byte processWithByteResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithByteResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte processWithByteResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Byte b = (Byte)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            byte by = b;
            return by;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public short processWithShortResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithShortResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short processWithShortResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Short b = (Short)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            short s = b;
            return s;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public long processWithLongResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithLongResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long processWithLongResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Long b = (Long)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            long l = b;
            return l;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public float processWithFloatResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithFloatResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float processWithFloatResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Float b = (Float)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            float f = b.floatValue();
            return f;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }

    public double processWithDoubleResult(UIDEx uid, Command cmd) throws SQLException {
        return this.processWithDoubleResult(uid, cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double processWithDoubleResult(UIDEx uid, Command cmd, boolean withCallingContext) throws SQLException {
        try {
            CallingContext ctx = null;
            if (withCallingContext) {
                ctx = this._callingContextFactory.create();
            }
            this._listener.preExecution(cmd);
            Double b = (Double)this._targetSink.process(this._connectionUid.getUID(), uid.getUID(), cmd, ctx);
            double d = b;
            return d;
        }
        finally {
            this._listener.postExecution(cmd);
        }
    }
}

