/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;

public class MRUtil {
    public static final String PROPERTY_PENTAHO_KETTLE_PLUGINS_DIR = "pentaho.kettle.plugins.dir";
    public static final String PROPERTY_PENTAHO_KETTLE_HOME = "pentaho.kettle.home";

    public static Trans getTrans(Configuration conf, String transXml, boolean singleThreaded) throws KettleException {
        MRUtil.initKettleEnvironment(conf);
        TransConfiguration transConfiguration = TransConfiguration.fromXML((String)transXml);
        TransMeta transMeta = transConfiguration.getTransMeta();
        String carteObjectId = UUID.randomUUID().toString();
        SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject("HADOOP_MAPPER", LoggingObjectType.CARTE, null);
        servletLoggingObject.setContainerObjectId(carteObjectId);
        TransExecutionConfiguration executionConfiguration = transConfiguration.getTransExecutionConfiguration();
        servletLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
        if (singleThreaded) {
            transMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
            transMeta.setUsingThreadPriorityManagment(false);
        } else {
            transMeta.setTransformationType(TransMeta.TransformationType.Normal);
        }
        return new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
    }

    private static void initKettleEnvironment(Configuration conf) throws KettleException {
        if (!KettleEnvironment.isInitialized()) {
            String kettleHome = MRUtil.getKettleHomeProperty(conf);
            String pluginDir = MRUtil.getPluginDirProperty(conf);
            System.setProperty("KETTLE_HOME", kettleHome);
            System.setProperty("KETTLE_PLUGIN_BASE_FOLDERS", pluginDir);
            System.out.println(BaseMessages.getString(MRUtil.class, (String)"KettleHome.Info", (String[])new String[]{kettleHome}));
            System.out.println(BaseMessages.getString(MRUtil.class, (String)"PluginDirectory.Info", (String[])new String[]{pluginDir}));
            KettleEnvironment.init();
        }
    }

    public static void passInformationToTransformation(VariableSpace variableSpace, JobConf job) {
        if (variableSpace != null && job != null) {
            int lastUnderscoreIndex;
            variableSpace.setVariable("Internal.Hadoop.NumMapTasks", Integer.toString(job.getNumMapTasks()));
            variableSpace.setVariable("Internal.Hadoop.NumReduceTasks", Integer.toString(job.getNumReduceTasks()));
            String taskId = job.get("mapred.task.id");
            variableSpace.setVariable("Internal.Hadoop.TaskId", taskId);
            String nodeNumber = Const.isEmpty((String)taskId) ? "0" : ((lastUnderscoreIndex = taskId.lastIndexOf("_")) >= 0 ? taskId.substring(lastUnderscoreIndex + 1) : "0");
            variableSpace.setVariable("Internal.Hadoop.NodeNumber", Integer.toString(Integer.valueOf(nodeNumber)));
        }
    }

    public static String getWorkingDir() {
        return System.getProperty("user.dir");
    }

    public static String getKettleHomeProperty(Configuration conf) {
        String kettleHome = conf.get(PROPERTY_PENTAHO_KETTLE_HOME);
        if (StringUtils.isEmpty((String)kettleHome)) {
            return MRUtil.getWorkingDir();
        }
        return kettleHome;
    }

    public static String getPluginDirProperty(Configuration conf) throws KettleException {
        String kettlePluginDir = conf.get(PROPERTY_PENTAHO_KETTLE_PLUGINS_DIR);
        if (StringUtils.isEmpty((String)kettlePluginDir)) {
            kettlePluginDir = MRUtil.getWorkingDir();
        }
        kettlePluginDir = Const.DEFAULT_PLUGIN_BASE_FOLDERS + "," + kettlePluginDir;
        return kettlePluginDir;
    }

    public static Trans recreateTrans(Trans trans) {
        return new Trans(trans.getTransMeta(), trans.getParent());
    }

    public static String getStackTrace(Throwable t) {
        StringWriter stringWritter = new StringWriter();
        PrintWriter printWritter = new PrintWriter((Writer)stringWritter, true);
        t.printStackTrace(printWritter);
        printWritter.flush();
        stringWritter.flush();
        return stringWritter.toString();
    }

    public static void logMessage(String message) {
        MRUtil.logMessage(Thread.currentThread().hashCode(), message);
    }

    public static void logMessage(Throwable t) {
        MRUtil.logMessage(Thread.currentThread().hashCode(), MRUtil.getStackTrace(t));
    }

    public static void logMessage(String message, Throwable t) {
        MRUtil.logMessage(Thread.currentThread().hashCode(), message);
        MRUtil.logMessage(Thread.currentThread().hashCode(), MRUtil.getStackTrace(t));
    }

    public static void logMessage(int id, String message) {
        MRUtil.logMessage(new Integer(id).toString(), message);
    }

    public static void logMessage(int id, Throwable t) {
        MRUtil.logMessage(new Integer(id).toString(), MRUtil.getStackTrace(t));
    }

    public static void logMessage(int id, String message, Throwable t) {
        MRUtil.logMessage(new Integer(id).toString(), message);
        MRUtil.logMessage(new Integer(id).toString(), MRUtil.getStackTrace(t));
    }

    public static void logMessage(String id, String message) {
        try {
            FileOutputStream fos = new FileOutputStream("/tmp/PDIMapReduce.log", true);
            if (id != null) {
                fos.write((id + ": ").getBytes());
            }
            fos.write(message.getBytes());
            fos.write(System.getProperty("line.separator").getBytes());
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

