/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputDiscoverFieldsHolder;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;
import org.pentaho.mongo.wrapper.cursor.MongoCursorWrapper;
import org.pentaho.mongo.wrapper.field.MongoArrayExpansion;
import org.pentaho.mongo.wrapper.field.MongoField;

public class MongoDbInputData
extends BaseStepData
implements StepDataInterface {
    public static final int MONGO_DEFAULT_PORT = 27017;
    public RowMetaInterface outputRowMeta;
    public MongoClientWrapper clientWrapper;
    public MongoCollectionWrapper collection;
    public MongoCursorWrapper cursor;
    Iterator<DBObject> m_pipelineResult;
    private List<MongoField> m_userFields;
    private MongoArrayExpansion m_expansionHandler;
    private static MongoDbInputDiscoverFieldsHolder mongoDbInputDiscoverFieldsHolder = MongoDbInputDiscoverFieldsHolder.getInstance();

    public static MongoDbInputDiscoverFieldsHolder getMongoDbInputDiscoverFieldsHolder() {
        return mongoDbInputDiscoverFieldsHolder;
    }

    protected void setMongoDbInputDiscoverFieldsHolder(MongoDbInputDiscoverFieldsHolder holder) {
        mongoDbInputDiscoverFieldsHolder = holder;
    }

    protected static MongoArrayExpansion checkFieldPaths(List<MongoField> normalFields, RowMetaInterface outputRowMeta) throws KettleException {
        String expansion = null;
        ArrayList<MongoField> normalList = new ArrayList<MongoField>();
        ArrayList<MongoField> expansionList = new ArrayList<MongoField>();
        for (MongoField f : normalFields) {
            String path = f.m_fieldPath;
            if (path != null && path.lastIndexOf("[*]") >= 0) {
                if (path.indexOf("[*]") != path.lastIndexOf("[*]")) {
                    throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoInput.ErrorMessage.PathContainsMultipleExpansions", (String[])new String[]{path}));
                }
                String pathPart = path.substring(0, path.lastIndexOf("[*]") + 3);
                if (expansion == null) {
                    expansion = pathPart;
                } else if (!expansion.equals(pathPart)) {
                    throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MutipleDifferentExpansions", (String[])new String[0]));
                }
                expansionList.add(f);
                continue;
            }
            normalList.add(f);
        }
        normalFields.clear();
        for (MongoField f : normalList) {
            normalFields.add(f);
        }
        if (expansionList.size() > 0) {
            ArrayList<MongoField> subFields = new ArrayList<MongoField>();
            for (MongoField ef : expansionList) {
                MongoField subField = new MongoField();
                subField.m_fieldName = ef.m_fieldName;
                String path = ef.m_fieldPath;
                if (path.charAt(path.length() - 2) == '*') {
                    path = "dummy";
                } else {
                    path = path.substring(path.lastIndexOf("[*]") + 3, path.length());
                    path = "$" + path;
                }
                subField.m_fieldPath = path;
                subField.m_indexedVals = ef.m_indexedVals;
                subField.m_kettleType = ef.m_kettleType;
                subFields.add(subField);
            }
            MongoArrayExpansion exp = new MongoArrayExpansion(subFields);
            exp.m_expansionPath = expansion;
            exp.m_outputRowMeta = outputRowMeta;
            return exp;
        }
        return null;
    }

    public void init() throws KettleException {
        if (this.m_userFields != null) {
            this.m_expansionHandler = MongoDbInputData.checkFieldPaths(this.m_userFields, this.outputRowMeta);
            for (MongoField f : this.m_userFields) {
                int outputIndex = this.outputRowMeta.indexOfValue(f.m_fieldName);
                f.init(outputIndex);
            }
            if (this.m_expansionHandler != null) {
                this.m_expansionHandler.init();
            }
        }
    }

    public Object[][] mongoDocumentToKettle(DBObject mongoObj, VariableSpace space) throws KettleException {
        Object[][] result = null;
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.reset(space);
            result = mongoObj instanceof BasicDBObject ? this.m_expansionHandler.convertToKettleValue((BasicDBObject)mongoObj, space) : this.m_expansionHandler.convertToKettleValue((BasicDBList)mongoObj, space);
        } else {
            result = new Object[1][];
        }
        Object[] normalData = RowDataUtil.allocateRowData((int)this.outputRowMeta.size());
        for (MongoField f : this.m_userFields) {
            Object value = null;
            f.reset(space);
            if (mongoObj instanceof BasicDBObject) {
                value = f.convertToKettleValue((BasicDBObject)mongoObj);
            } else if (mongoObj instanceof BasicDBList) {
                value = f.convertToKettleValue((BasicDBList)mongoObj);
            }
            normalData[f.m_outputIndex] = value;
        }
        if (this.m_expansionHandler == null) {
            result[0] = normalData;
        } else {
            for (int i = 0; i < result.length; ++i) {
                Object[] row = result[i];
                for (MongoField f : this.m_userFields) {
                    row[f.m_outputIndex] = normalData[f.m_outputIndex];
                }
            }
        }
        return result;
    }

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }

    public void setMongoFields(List<MongoField> fields) {
        this.m_userFields = new ArrayList<MongoField>();
        for (MongoField f : fields) {
            this.m_userFields.add(f.copy());
        }
    }

    public static String indexedValsList(List<String> indexedVals) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < indexedVals.size(); ++i) {
            temp.append(indexedVals.get(i));
            if (i >= indexedVals.size() - 1) continue;
            temp.append(",");
        }
        return temp.toString();
    }

    public static List<String> indexedValsList(String indexedVals) {
        String[] parts = indexedVals.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : parts) {
            list.add(s.trim());
        }
        return list;
    }
}

