/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.obs.IBitSet;

public abstract class BloomFilter
implements IFilter {
    private static final ThreadLocal<long[]> reusableIndexes = new ThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[21];
        }
    };
    public final IBitSet bitset;
    public final int hashCount;

    BloomFilter(int hashes, IBitSet bitset) {
        this.hashCount = hashes;
        this.bitset = bitset;
    }

    protected abstract void hash(ByteBuffer var1, int var2, int var3, long var4, long[] var6);

    @VisibleForTesting
    public long[] getHashBuckets(ByteBuffer key, int hashCount, long max) {
        long[] hash = new long[2];
        this.hash(key, key.position(), key.remaining(), 0L, hash);
        long[] indexes = new long[hashCount];
        this.setIndexes(hash[0], hash[1], hashCount, max, indexes);
        return indexes;
    }

    private long[] indexes(ByteBuffer key) {
        long[] indexes = reusableIndexes.get();
        this.hash(key, key.position(), key.remaining(), 0L, indexes);
        this.setIndexes(indexes[0], indexes[1], this.hashCount, this.bitset.capacity(), indexes);
        return indexes;
    }

    private void setIndexes(long base, long inc, int count, long max, long[] results) {
        for (int i = 0; i < count; ++i) {
            results[i] = FBUtilities.abs(base % max);
            base += inc;
        }
    }

    @Override
    public void add(ByteBuffer key) {
        long[] indexes = this.indexes(key);
        for (int i = 0; i < this.hashCount; ++i) {
            this.bitset.set(indexes[i]);
        }
    }

    @Override
    public final boolean isPresent(ByteBuffer key) {
        long[] indexes = this.indexes(key);
        for (int i = 0; i < this.hashCount; ++i) {
            if (this.bitset.get(indexes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.bitset.clear();
    }

    @Override
    public void close() throws IOException {
        this.bitset.close();
    }
}

