/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;

public class NumberUtil {
    public static final BigDecimal DELTA = new BigDecimal("0.000000000000000000000000000000000000005");
    public static final BigDecimal INT_TEST_DELTA = new BigDecimal("0.00000000000000000000000000000000005");
    private static final int ROUND_SCALE = 34;

    private NumberUtil() {
    }

    public static BigDecimal getAsBigDecimal(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    public static BigDecimal performIntRounding(BigDecimal n) {
        try {
            return n.setScale(0);
        }
        catch (ArithmeticException arithmeticException) {
            if (n.signum() < 0) {
                n = n.subtract(DELTA);
                return n.setScale(0, 0);
            }
            n = n.add(DELTA);
            BigDecimal round = n.setScale(1, 1);
            return round.setScale(0, 1);
        }
    }

    public static BigDecimal performTuneRounding(BigDecimal n) {
        try {
            n.setScale(34);
            return n;
        }
        catch (ArithmeticException arithmeticException) {
            BigDecimal round;
            if (n.signum() < 0) {
                n = n.subtract(INT_TEST_DELTA);
                round = n.setScale(34, 0);
            } else {
                n = n.add(INT_TEST_DELTA);
                round = n.setScale(34, 1);
            }
            if (n.compareTo(round) == 0) {
                return n;
            }
            return NumberUtil.removeTrailingZeros(round);
        }
    }

    public static BigDecimal removeTrailingZeros(BigDecimal bd) {
        char c;
        if (bd.signum() == 0) {
            return bd.setScale(0);
        }
        String text = bd.toPlainString();
        int scale = bd.scale();
        for (int i = text.length() - 1; i >= 0 && (c = text.charAt(i)) == '0'; --i) {
            --scale;
        }
        return bd.setScale(scale);
    }

    public static BigDecimal divide(BigDecimal bd1, BigDecimal bd2) throws EvaluationException {
        if (bd2.signum() == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
        }
        BigDecimal divide = bd1.divide(bd2, 40, 4);
        return NumberUtil.removeTrailingZeros(divide);
    }
}

