/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriterSupport;

public class XmlWriter {
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private Writer writer;
    private XmlWriterSupport support;

    public XmlWriter(Writer writer) {
        this(writer, "  ");
    }

    public XmlWriter(Writer writer, TagDescription tagDescription) {
        this(writer, tagDescription, "  ");
    }

    public XmlWriter(Writer writer, String indentString) {
        this(writer, new DefaultTagDescription(), indentString);
    }

    public XmlWriter(Writer writer, TagDescription tagDescription, String indentString) {
        if (writer == null) {
            throw new NullPointerException("Writer must not be null.");
        }
        this.support = new XmlWriterSupport(tagDescription, indentString);
        this.writer = writer;
    }

    public XmlWriter(Writer writer, TagDescription tagDescription, String indentString, String lineSeparator) {
        if (writer == null) {
            throw new NullPointerException("Writer must not be null.");
        }
        this.support = new XmlWriterSupport(tagDescription, indentString, lineSeparator);
        this.writer = writer;
    }

    public void writeXmlDeclaration(String encoding) throws IOException {
        this.support.writeXmlDeclaration(this.writer, encoding);
    }

    public void writeTag(String namespace, String name, boolean close) throws IOException {
        if (close) {
            this.support.writeTag(this.writer, namespace, name, null, true);
        } else {
            this.support.writeTag(this.writer, namespace, name, null, false);
        }
    }

    public void writeCloseTag() throws IOException {
        this.support.writeCloseTag(this.writer);
    }

    public void writeTag(String namespace, String name, String attributeName, String attributeValue, boolean close) throws IOException {
        this.support.writeTag(this.writer, namespace, name, attributeName, attributeValue, close);
    }

    public void writeTag(String namespace, String name, AttributeList attributes, boolean close) throws IOException {
        this.support.writeTag(this.writer, namespace, name, attributes, close);
    }

    public void writeText(String text) throws IOException {
        this.writer.write(text);
        this.support.setLineEmpty(false);
    }

    public void writeTextNormalized(String s, boolean transformNewLine) throws IOException {
        this.support.writeTextNormalized(this.writer, s, transformNewLine);
    }

    public void writeStream(Reader reader) throws IOException {
        IOUtils.getInstance().copyWriter(reader, this.writer);
        this.support.setLineEmpty(false);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void writeComment(String comment) throws IOException {
        this.support.writeComment(this.writer, comment);
    }

    public void writeNewLine() throws IOException {
        this.support.writeNewLine(this.writer);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public boolean isNamespaceDefined(String namespace) {
        return this.support.isNamespaceDefined(namespace);
    }

    public void setAlwaysAddNamespace(boolean b) {
        this.support.setAlwaysAddNamespace(b);
    }

    public void addImpliedNamespace(String uri, String prefix) {
        this.support.addImpliedNamespace(uri, prefix);
    }

    public void setAssumeDefaultNamespace(boolean assumeDefaultNamespace) {
        this.support.setAssumeDefaultNamespace(assumeDefaultNamespace);
    }

    public boolean isAssumeDefaultNamespace() {
        return this.support.isAssumeDefaultNamespace();
    }

    public boolean isAlwaysAddNamespace() {
        return this.support.isAlwaysAddNamespace();
    }

    public void setHtmlCompatiblityMode(boolean htmlCompatiblityMode) {
        this.support.setHtmlCompatiblityMode(htmlCompatiblityMode);
    }

    public boolean isHtmlCompatiblityMode() {
        return this.support.isHtmlCompatiblityMode();
    }

    public void setWriteFinalLinebreak(boolean writeFinalLinebreak) {
        this.support.setWriteFinalLinebreak(writeFinalLinebreak);
    }

    public boolean isWriteFinalLinebreak() {
        return this.support.isWriteFinalLinebreak();
    }

    public void setEncoding(String encoding) {
        this.support.setEncoding(encoding);
    }

    public void setLineEmpty(boolean lineEmpty) {
        this.support.setLineEmpty(lineEmpty);
    }

    public boolean isLineEmpty() {
        return this.support.isLineEmpty();
    }

    public boolean isNamespacePrefixDefined(String prefix) {
        return this.support.isNamespacePrefixDefined(prefix);
    }

    public int getAdditionalIndent() {
        return this.support.getAdditionalIndent();
    }

    public void setAdditionalIndent(int additionalIndent) {
        this.support.setAdditionalIndent(additionalIndent);
    }

    public TagDescription getTagDescription() {
        return this.support.getTagDescription();
    }
}

