/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.LocationMode;
import com.microsoft.windowsazure.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.storage.ServiceClient;
import com.microsoft.windowsazure.storage.core.Utility;
import java.util.Date;

public abstract class RequestOptions {
    private RetryPolicyFactory retryPolicyFactory;
    private Integer timeoutIntervalInMs;
    private LocationMode locationMode;
    private Integer maximumExecutionTimeInMs;
    private Long operationExpiryTime;

    public RequestOptions() {
    }

    public RequestOptions(RequestOptions other) {
        if (other != null) {
            this.setRetryPolicyFactory(other.getRetryPolicyFactory());
            this.setTimeoutIntervalInMs(other.getTimeoutIntervalInMs());
            this.setLocationMode(other.getLocationMode());
            this.setMaximumExecutionTimeInMs(other.getMaximumExecutionTimeInMs());
            this.setOperationExpiryTimeInMs(other.getOperationExpiryTimeInMs());
        }
    }

    protected static final RequestOptions applyBaseDefaultsInternal(RequestOptions modifiedOptions, ServiceClient client) {
        return RequestOptions.applyBaseDefaultsInternal(modifiedOptions, client, true);
    }

    protected static final RequestOptions applyBaseDefaultsInternal(RequestOptions modifiedOptions, ServiceClient client, boolean setStartTime) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        if (modifiedOptions.getRetryPolicyFactory() == null) {
            modifiedOptions.setRetryPolicyFactory(client.getRetryPolicyFactory());
        }
        if (modifiedOptions.getTimeoutIntervalInMs() == null) {
            modifiedOptions.setTimeoutIntervalInMs(client.getTimeoutInMs());
        }
        if (modifiedOptions.getLocationMode() == null) {
            modifiedOptions.setLocationMode(client.getLocationMode());
        }
        if (modifiedOptions.getMaximumExecutionTimeInMs() == null) {
            modifiedOptions.setMaximumExecutionTimeInMs(client.getMaximumExecutionTimeInMs());
        }
        if (modifiedOptions.getMaximumExecutionTimeInMs() != null && modifiedOptions.getOperationExpiryTimeInMs() == null && setStartTime) {
            modifiedOptions.setOperationExpiryTimeInMs(new Date().getTime() + (long)modifiedOptions.getMaximumExecutionTimeInMs().intValue());
        }
        return modifiedOptions;
    }

    public final RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public final Integer getTimeoutIntervalInMs() {
        return this.timeoutIntervalInMs;
    }

    public final LocationMode getLocationMode() {
        return this.locationMode;
    }

    public Integer getMaximumExecutionTimeInMs() {
        return this.maximumExecutionTimeInMs;
    }

    public Long getOperationExpiryTimeInMs() {
        return this.operationExpiryTime;
    }

    public final void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
    }

    public final void setTimeoutIntervalInMs(Integer timeoutIntervalInMs) {
        this.timeoutIntervalInMs = timeoutIntervalInMs;
    }

    public final void setLocationMode(LocationMode locationMode) {
        this.locationMode = locationMode;
    }

    public void setMaximumExecutionTimeInMs(Integer maximumExecutionTimeInMs) {
        this.maximumExecutionTimeInMs = maximumExecutionTimeInMs;
    }

    private void setOperationExpiryTimeInMs(Long operationExpiryTime) {
        this.operationExpiryTime = operationExpiryTime;
    }
}

