/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.ResultContinuation;
import com.microsoft.windowsazure.storage.ResultContinuationType;
import com.microsoft.windowsazure.storage.ResultSegment;
import com.microsoft.windowsazure.storage.ServiceClient;
import com.microsoft.windowsazure.storage.ServiceProperties;
import com.microsoft.windowsazure.storage.ServiceStats;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAnonymous;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobDeserializer;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.ContainerListingDetails;
import com.microsoft.windowsazure.storage.blob.ContainerRequest;
import com.microsoft.windowsazure.storage.core.ExecutionEngine;
import com.microsoft.windowsazure.storage.core.LazySegmentedIterable;
import com.microsoft.windowsazure.storage.core.ListResponse;
import com.microsoft.windowsazure.storage.core.ListingContext;
import com.microsoft.windowsazure.storage.core.SegmentedStorageRequest;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

public final class CloudBlobClient
extends ServiceClient {
    private int singleBlobPutThresholdInBytes = 0x2000000;
    private int concurrentRequestCount = 1;
    private String directoryDelimiter = "/";

    public CloudBlobClient(URI baseUri) {
        this(new StorageUri(baseUri), StorageCredentialsAnonymous.ANONYMOUS);
    }

    public CloudBlobClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public CloudBlobClient(StorageUri storageUri, StorageCredentials credentials) {
        super(storageUri, credentials);
    }

    public int getConcurrentRequestCount() {
        return this.concurrentRequestCount;
    }

    public CloudBlobContainer getContainerReference(String containerName) throws URISyntaxException, StorageException {
        return new CloudBlobContainer(containerName, this);
    }

    public String getDirectoryDelimiter() {
        return this.directoryDelimiter;
    }

    public int getSingleBlobPutThresholdInBytes() {
        return this.singleBlobPutThresholdInBytes;
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers() throws StorageException {
        return this.listContainersWithPrefix(null, ContainerListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix) throws StorageException {
        return this.listContainersWithPrefix(prefix, ContainerListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudBlobContainer> listContainers(String prefix, ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listContainersWithPrefix(prefix, detailsIncluded, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented() throws StorageException {
        return this.listContainersSegmented(null, ContainerListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix) throws StorageException {
        return this.listContainersWithPrefixSegmented(prefix, ContainerListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudBlobContainer> listContainersSegmented(String prefix, ContainerListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listContainersWithPrefixSegmented(prefix, detailsIncluded, maxResults, continuationToken, options, opContext);
    }

    private Iterable<CloudBlobContainer> listContainersWithPrefix(String prefix, ContainerListingDetails detailsIncluded, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.UNSPECIFIED, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudBlobClient, Object, CloudBlobContainer>(this.listContainersWithPrefixSegmentedImpl(prefix, detailsIncluded, -1, options, segmentedRequest), this, null, options.getRetryPolicyFactory(), opContext);
    }

    private ResultSegment<CloudBlobContainer> listContainersWithPrefixSegmented(String prefix, ContainerListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.UNSPECIFIED, this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.CONTAINER);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, null, this.listContainersWithPrefixSegmentedImpl(prefix, detailsIncluded, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> listContainersWithPrefixSegmentedImpl(String prefix, final ContainerListingDetails detailsIncluded, final int maxResults, final BlobRequestOptions options, final SegmentedStorageRequest segmentedRequest) throws StorageException {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.CONTAINER);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>> getRequest = new StorageRequest<CloudBlobClient, Void, ResultSegment<CloudBlobContainer>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, Void parentObject, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return ContainerRequest.list(client.getEndpoint(), options.getTimeoutIntervalInMs(), listingContext, detailsIncluded, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public ResultSegment<CloudBlobContainer> preProcessResponse(Void parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<CloudBlobContainer> postProcessResponse(HttpURLConnection connection, Void container, CloudBlobClient client, OperationContext context, ResultSegment<CloudBlobContainer> storageObject) throws Exception {
                ListResponse<CloudBlobContainer> response = BlobDeserializer.getContainerList(this.getConnection().getInputStream(), client);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.CONTAINER);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<CloudBlobContainer> resSegment = new ResultSegment<CloudBlobContainer>(response.getResults(), maxResults, newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats() throws StorageException {
        return this.getServiceStats(null, null);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.UNSPECIFIED, this);
        return ExecutionEngine.executeWithRetry(this, null, this.getServiceStatsImpl(options, false), this.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties(BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.UNSPECIFIED, this);
        return ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, false), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.UNSPECIFIED, this);
        Utility.assertNotNull("properties", properties);
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties, options, opContext, false), options.getRetryPolicyFactory(), opContext);
    }

    public void setConcurrentRequestCount(int concurrentRequestCount) {
        this.concurrentRequestCount = concurrentRequestCount;
    }

    public void setDirectoryDelimiter(String directoryDelimiter) {
        Utility.assertNotNullOrEmpty("directoryDelimiter", directoryDelimiter);
        this.directoryDelimiter = directoryDelimiter;
    }

    public void setSingleBlobPutThresholdInBytes(int singleBlobPutThresholdInBytes) {
        if (singleBlobPutThresholdInBytes > 0x4000000 || singleBlobPutThresholdInBytes < 0x100000) {
            throw new IllegalArgumentException("SingleBlobUploadThresholdInBytes");
        }
        this.singleBlobPutThresholdInBytes = singleBlobPutThresholdInBytes;
    }
}

