/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class DeserializationHelper {
    private static final XMLInputFactory xmlif = XMLInputFactory.newInstance();

    public static HashMap<String, String> parseMetadateFromXML(XMLStreamReader xmlr) throws XMLStreamException {
        HashMap<String, String> retVals = new HashMap<String, String>();
        xmlr.require(1, null, "Metadata");
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            String tValue;
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 2 && "Metadata".equals(name)) break;
            if ("x-ms-invalid-name".equals(name) || eventType != 1 || Utility.isNullOrEmpty(tValue = DeserializationHelper.readElementFromXMLReader(xmlr, name))) continue;
            retVals.put(name, tValue);
        }
        return retVals;
    }

    public static XMLStreamReader createXMLStreamReaderFromReader(Reader reader) throws XMLStreamException {
        return xmlif.createXMLStreamReader(reader);
    }

    public static XMLStreamReader createXMLStreamReaderFromStream(InputStream streamRef) throws XMLStreamException {
        return xmlif.createXMLStreamReader(streamRef, "UTF-8");
    }

    public static String readElementFromXMLReader(XMLStreamReader xmlr, String elementName) throws XMLStreamException {
        return DeserializationHelper.readElementFromXMLReader(xmlr, elementName, true);
    }

    public static String readElementFromXMLReader(XMLStreamReader xmlr, String elementName, boolean returnNullOnEmpty) throws XMLStreamException {
        xmlr.require(1, null, elementName);
        int eventType = xmlr.next();
        StringBuilder retVal = new StringBuilder();
        if (eventType == 4) {
            do {
                retVal.append(xmlr.getText());
            } while ((eventType = xmlr.next()) == 4);
        }
        xmlr.require(2, null, elementName);
        if (retVal.length() == 0) {
            return returnNullOnEmpty ? null : "";
        }
        return retVal.toString();
    }

    public static String readETagFromXMLReader(XMLStreamReader xmlr) throws XMLStreamException {
        String etag = DeserializationHelper.readElementFromXMLReader(xmlr, "Etag", true);
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag;
        }
        return String.format("\"%s\"", etag);
    }

    private DeserializationHelper() {
    }

    static {
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }
}

