/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.mapr.osgi.jaas;

import com.sun.security.auth.login.ConfigFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.HadoopConfigurationListener;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprJaasRealmsRegistrar
implements HadoopConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaprJaasRealmsRegistrar.class);
    private BundleContext bundleContext;
    private List<ServiceRegistration> realmRegistrations;

    public MaprJaasRealmsRegistrar(BundleContext bundleContext) throws ConfigurationException {
        this.bundleContext = bundleContext;
        HadoopConfigurationBootstrap hcb = HadoopConfigurationBootstrap.getInstance();
        hcb.registerHadoopConfigurationListener((HadoopConfigurationListener)this);
        hcb.notifyDependencyLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClassLoaderAvailable(ClassLoader classLoader) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            if (!this.isMaprShimActive(HadoopConfigurationBootstrap.getInstance())) {
                LOGGER.info("Active hadoop configuration is not MapR. Skipping JAAS realms registration.");
                return;
            }
            HashMap<String, LinkedList<AppConfigurationEntry>> configs = this.getMaprJaasConfig();
            this.realmRegistrations = new ArrayList<ServiceRegistration>(configs.size());
            for (String realmName : configs.keySet()) {
                JaasRealm realm = this.createJaasRealm(realmName, (List<AppConfigurationEntry>)configs.get(realmName));
                ServiceRegistration reg = this.getBundleContext().registerService(JaasRealm.class.getCanonicalName(), (Object)realm, null);
                this.realmRegistrations.add(reg);
            }
            LOGGER.debug(String.format("Registered %s JAAS realms using system properties.", this.realmRegistrations.size()));
        }
        catch (Exception e) {
            LOGGER.error("Error during setting up MapR JAAS configuration", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public void onConfigurationOpen(HadoopConfiguration hadoopConfiguration, boolean defaultConfiguration) {
    }

    public void onConfigurationClose(HadoopConfiguration hadoopConfiguration) {
        if (this.realmRegistrations != null) {
            for (ServiceRegistration realmRegistration : this.realmRegistrations) {
                realmRegistration.unregister();
            }
            this.realmRegistrations = null;
        }
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, LinkedList<AppConfigurationEntry>> getMaprJaasConfig() throws Exception {
        try {
            HashMap configs;
            if (Const.isEmpty((String)System.getProperty("java.security.auth.login.config"))) {
                Thread.currentThread().getContextClassLoader().loadClass("com.mapr.baseutils.JVMProperties").newInstance();
            }
            Object config = new ConfigFile();
            try {
                Field spi = config.getClass().getDeclaredField("spi");
                boolean accessible = spi.isAccessible();
                if (!accessible) {
                    spi.setAccessible(true);
                }
                try {
                    config = spi.get(config);
                }
                finally {
                    if (!accessible) {
                        spi.setAccessible(accessible);
                    }
                }
            }
            catch (NoSuchFieldException spi) {
                // empty catch block
            }
            Field f = config.getClass().getDeclaredField("configuration");
            boolean accessible = f.isAccessible();
            if (!accessible) {
                f.setAccessible(true);
            }
            try {
                configs = (HashMap)f.get(config);
            }
            finally {
                if (!accessible) {
                    f.setAccessible(accessible);
                }
            }
            if (configs == null) {
                throw new IllegalArgumentException("JAAS configuration is not available");
            }
            return configs;
        }
        catch (Exception e) {
            throw new IllegalStateException("JAAS configuration could not be loaded at this time", e);
        }
    }

    private JaasRealm createJaasRealm(final String realmName, final List<AppConfigurationEntry> entries) {
        return new JaasRealm(){

            public String getName() {
                return realmName;
            }

            public int getRank() {
                return 0;
            }

            public AppConfigurationEntry[] getEntries() {
                return entries.toArray(new AppConfigurationEntry[entries.size()]);
            }
        };
    }

    boolean isMaprShimActive(HadoopConfigurationBootstrap hadoopConfigurationBootstrap) {
        try {
            String configurationId = hadoopConfigurationBootstrap.getActiveConfigurationId();
            LOGGER.debug("Active shim configuration is " + configurationId);
            return configurationId != null && configurationId.matches("mapr\\d+");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }
}

