/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.AUI;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CP;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class IN1
extends AbstractSegment {
    public IN1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - IN1");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage(), new Integer(72)}, "Insurance Plan ID");
            this.add(CX.class, true, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Company ID");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Company Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Company Address");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Co Contact Person");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Co Phone Number");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Group Number");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Group Name");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Group Emp ID");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Group Emp Name");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Plan Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Plan Expiration Date");
            this.add(AUI.class, false, 1, 239, new Object[]{this.getMessage(), new Integer(0)}, "Authorization Information");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage()}, "Plan Type");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Name Of Insured");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(63)}, "Insured's Relationship To Patient");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Date Of Birth");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Address");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Assignment Of Benefits");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Coordination Of Benefits");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Coord Of Ben. Priority");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Notice Of Admission Flag");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Notice Of Admission Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Report Of Eligibility Flag");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Report Of Eligibility Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Release Information Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage(), new Integer(0)}, "Pre-Admit Cert (PAC)");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Verification Date/Time");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Verification By");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Type Of Agreement Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Billing Status");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Lifetime Reserve Days");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Delay Before L.R. Day");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage()}, "Company Plan Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage(), new Integer(0)}, "Policy Number");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Policy Deductible");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Policy Limit - Amount");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Policy Limit - Days");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Room Rate - Semi-Private");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Room Rate - Private");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(66)}, "Insured's Employment Status");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Insured's Administrative Sex");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Employer's Address");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Verification Status");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage()}, "Prior Insurance Plan ID");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage()}, "Coverage Type");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Handicap");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insured's ID Number");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Signature Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Signature Code Date");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Insured_s Birth Place");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "VIP Indicator");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating IN1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDIN1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getIn11_SetIDIN1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getInsurancePlanID() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn12_InsurancePlanID() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX[] getInsuranceCompanyID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getInsuranceCompanyID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn13_InsuranceCompanyID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX insertInsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX insertIn13_InsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX removeInsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX removeIn13_InsuranceCompanyID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public XON[] getInsuranceCompanyName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getInsuranceCompanyName(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getIn14_InsuranceCompanyName(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON insertInsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(4, rep);
    }

    public XON insertIn14_InsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(4, rep);
    }

    public XON removeInsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(4, rep);
    }

    public XON removeIn14_InsuranceCompanyName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(4, rep);
    }

    public XAD[] getInsuranceCompanyAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getInsuranceCompanyAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getIn15_InsuranceCompanyAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD insertInsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD insertIn15_InsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD removeInsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XAD removeIn15_InsuranceCompanyAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XPN[] getInsuranceCoContactPerson() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getInsuranceCoContactPerson(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn16_InsuranceCoContactPerson(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN insertInsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN insertIn16_InsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN removeInsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public XPN removeIn16_InsuranceCoContactPerson(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public XTN[] getInsuranceCoPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getInsuranceCoPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getIn17_InsuranceCoPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN insertInsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN insertIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN removeInsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public XTN removeIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public ST getGroupNumber() {
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn18_GroupNumber() {
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON[] getGroupName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getGroupName(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getIn19_GroupName(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON insertGroupName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(9, rep);
    }

    public XON insertIn19_GroupName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(9, rep);
    }

    public XON removeGroupName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(9, rep);
    }

    public XON removeIn19_GroupName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(9, rep);
    }

    public CX[] getInsuredSGroupEmpID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(10);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getInsuredSGroupEmpID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn110_InsuredSGroupEmpID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX insertInsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX insertIn110_InsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX removeInsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CX removeIn110_InsuredSGroupEmpID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public XON[] getInsuredSGroupEmpName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(11);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getInsuredSGroupEmpName(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getIn111_InsuredSGroupEmpName(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON insertInsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(11, rep);
    }

    public XON insertIn111_InsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(11, rep);
    }

    public XON removeInsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(11, rep);
    }

    public XON removeIn111_InsuredSGroupEmpName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(11, rep);
    }

    public DT getPlanEffectiveDate() {
        DT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn112_PlanEffectiveDate() {
        DT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getPlanExpirationDate() {
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn113_PlanExpirationDate() {
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public AUI getAuthorizationInformation() {
        AUI ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (AUI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public AUI getIn114_AuthorizationInformation() {
        AUI ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (AUI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPlanType() {
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn115_PlanType() {
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getNameOfInsured() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getNameOfInsured(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn116_NameOfInsured(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN insertNameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN insertIn116_NameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN removeNameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public XPN removeIn116_NameOfInsured(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public CE getInsuredSRelationshipToPatient() {
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn117_InsuredSRelationshipToPatient() {
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getInsuredSDateOfBirth() {
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getIn118_InsuredSDateOfBirth() {
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD[] getInsuredSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getInsuredSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getIn119_InsuredSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD insertInsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(19, rep);
    }

    public XAD insertIn119_InsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(19, rep);
    }

    public XAD removeInsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(19, rep);
    }

    public XAD removeIn119_InsuredSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(19, rep);
    }

    public IS getAssignmentOfBenefits() {
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn120_AssignmentOfBenefits() {
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getCoordinationOfBenefits() {
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn121_CoordinationOfBenefits() {
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getCoordOfBenPriority() {
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn122_CoordOfBenPriority() {
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getNoticeOfAdmissionFlag() {
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn123_NoticeOfAdmissionFlag() {
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getNoticeOfAdmissionDate() {
        DT ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn124_NoticeOfAdmissionDate() {
        DT ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getReportOfEligibilityFlag() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn125_ReportOfEligibilityFlag() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getReportOfEligibilityDate() {
        DT ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn126_ReportOfEligibilityDate() {
        DT ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getReleaseInformationCode() {
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn127_ReleaseInformationCode() {
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPreAdmitCert() {
        ST ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn128_PreAdmitCert() {
        ST ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getVerificationDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getIn129_VerificationDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getVerificationBy() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(30);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getVerificationBy(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getIn130_VerificationBy(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN insertVerificationBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(30, rep);
    }

    public XCN insertIn130_VerificationBy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(30, rep);
    }

    public XCN removeVerificationBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(30, rep);
    }

    public XCN removeIn130_VerificationBy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(30, rep);
    }

    public IS getTypeOfAgreementCode() {
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn131_TypeOfAgreementCode() {
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getBillingStatus() {
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn132_BillingStatus() {
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getLifetimeReserveDays() {
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getIn133_LifetimeReserveDays() {
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getDelayBeforeLRDay() {
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getIn134_DelayBeforeLRDay() {
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getCompanyPlanCode() {
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn135_CompanyPlanCode() {
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPolicyNumber() {
        ST ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn136_PolicyNumber() {
        ST ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getPolicyDeductible() {
        CP ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getIn137_PolicyDeductible() {
        CP ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getPolicyLimitAmount() {
        CP ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getIn138_PolicyLimitAmount() {
        CP ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPolicyLimitDays() {
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getIn139_PolicyLimitDays() {
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getRoomRateSemiPrivate() {
        CP ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getIn140_RoomRateSemiPrivate() {
        CP ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getRoomRatePrivate() {
        CP ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getIn141_RoomRatePrivate() {
        CP ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getInsuredSEmploymentStatus() {
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn142_InsuredSEmploymentStatus() {
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getInsuredSAdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn143_InsuredSAdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD[] getInsuredSEmployerSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(44);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getInsuredSEmployerSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getIn144_InsuredSEmployerSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD insertInsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(44, rep);
    }

    public XAD insertIn144_InsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(44, rep);
    }

    public XAD removeInsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(44, rep);
    }

    public XAD removeIn144_InsuredSEmployerSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(44, rep);
    }

    public ST getVerificationStatus() {
        ST ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn145_VerificationStatus() {
        ST ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPriorInsurancePlanID() {
        IS ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn146_PriorInsurancePlanID() {
        IS ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getCoverageType() {
        IS ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn147_CoverageType() {
        IS ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getHandicap() {
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn148_Handicap() {
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX[] getInsuredSIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(49);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getInsuredSIDNumber(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(49, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn149_InsuredSIDNumber(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(49, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX insertInsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(49, rep);
    }

    public CX insertIn149_InsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(49, rep);
    }

    public CX removeInsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(49, rep);
    }

    public CX removeIn149_InsuredSIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(49, rep);
    }

    public IS getSignatureCode() {
        IS ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn150_SignatureCode() {
        IS ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getSignatureCodeDate() {
        DT ret = null;
        try {
            Type t = this.getField(51, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn151_SignatureCodeDate() {
        DT ret = null;
        try {
            Type t = this.getField(51, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getInsuredSBirthPlace() {
        ST ret = null;
        try {
            Type t = this.getField(52, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn152_InsuredSBirthPlace() {
        ST ret = null;
        try {
            Type t = this.getField(52, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getVIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(53, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn153_VIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(53, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XPN(this.getMessage());
            }
            case 6: {
                return new XTN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new XON(this.getMessage());
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new XON(this.getMessage());
            }
            case 11: {
                return new DT(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new AUI(this.getMessage());
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(86));
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new TS(this.getMessage());
            }
            case 18: {
                return new XAD(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(135));
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(173));
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new DT(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 25: {
                return new DT(this.getMessage());
            }
            case 26: {
                return new IS(this.getMessage(), new Integer(93));
            }
            case 27: {
                return new ST(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new XCN(this.getMessage());
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(98));
            }
            case 31: {
                return new IS(this.getMessage(), new Integer(22));
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new NM(this.getMessage());
            }
            case 34: {
                return new IS(this.getMessage(), new Integer(42));
            }
            case 35: {
                return new ST(this.getMessage());
            }
            case 36: {
                return new CP(this.getMessage());
            }
            case 37: {
                return new CP(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new CP(this.getMessage());
            }
            case 40: {
                return new CP(this.getMessage());
            }
            case 41: {
                return new CE(this.getMessage());
            }
            case 42: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 43: {
                return new XAD(this.getMessage());
            }
            case 44: {
                return new ST(this.getMessage());
            }
            case 45: {
                return new IS(this.getMessage(), new Integer(72));
            }
            case 46: {
                return new IS(this.getMessage(), new Integer(309));
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(295));
            }
            case 48: {
                return new CX(this.getMessage());
            }
            case 49: {
                return new IS(this.getMessage(), new Integer(535));
            }
            case 50: {
                return new DT(this.getMessage());
            }
            case 51: {
                return new ST(this.getMessage());
            }
            case 52: {
                return new IS(this.getMessage(), new Integer(99));
            }
        }
        return null;
    }
}

