/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hl7input.common;

import ca.uhn.hl7v2.protocol.StreamSource;
import ca.uhn.hl7v2.protocol.impl.MLLPTransport;
import ca.uhn.hl7v2.protocol.impl.ServerSocketStreamSource;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.trans.steps.hl7input.common.MLLPSocketCacheEntry;

public class MLLPSocketCache {
    private static MLLPSocketCache cache;
    private Map<String, MLLPSocketCacheEntry> map = new HashMap<String, MLLPSocketCacheEntry>();

    public static MLLPSocketCache getInstance() {
        if (cache == null) {
            cache = new MLLPSocketCache();
        }
        return cache;
    }

    public MLLPSocketCacheEntry getServerSocketStreamSource(String server, int port) throws Exception {
        final String key = this.createKey(server, port);
        MLLPSocketCacheEntry s = this.map.get(key);
        if (s != null) {
            return s;
        }
        ServerSocket serverSocket = new ServerSocket(port);
        ServerSocketStreamSource streamSource = new ServerSocketStreamSource(serverSocket, server);
        MLLPTransport transport = new MLLPTransport((StreamSource)streamSource);
        transport.connect();
        final MLLPSocketCacheEntry entry = new MLLPSocketCacheEntry(serverSocket, (StreamSource)streamSource, transport);
        entry.setJobListener((JobListener)new JobAdapter(){

            public void jobFinished(Job job) throws KettleException {
                KettleException exception = null;
                try {
                    entry.getTransport().disconnect();
                }
                catch (Exception e) {
                    exception = new KettleException((Throwable)e);
                }
                try {
                    entry.getStreamSource().disconnect();
                }
                catch (Exception e) {
                    exception = new KettleException((Throwable)e);
                }
                try {
                    entry.getServerSocket().close();
                }
                catch (Exception e) {
                    exception = new KettleException((Throwable)e);
                }
                MLLPSocketCache.this.map.remove(key);
                if (exception != null) {
                    throw exception;
                }
            }
        });
        this.map.put(key, new MLLPSocketCacheEntry(serverSocket, (StreamSource)streamSource, transport));
        return entry;
    }

    private String createKey(String server, int port) {
        return server + ":" + port;
    }
}

