/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.validate.template;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.Template;

public class RenderSearchTemplateRequest
extends ActionRequest<RenderSearchTemplateRequest> {
    private Template template;

    public void template(Template template) {
        this.template = template;
    }

    public Template template() {
        return this.template;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.template == null) {
            exception = new ActionRequestValidationException();
            exception.addValidationError("template must not be null");
        }
        return exception;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        boolean hasTemplate = this.template != null;
        out.writeBoolean(hasTemplate);
        if (hasTemplate) {
            this.template.writeTo(out);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.template = Template.readTemplate(in);
        }
    }
}

