/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.joda.Joda;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public enum DateTimeUnit {
    WEEK_OF_WEEKYEAR(1, ISOChronology.getInstanceUTC().weekOfWeekyear()),
    YEAR_OF_CENTURY(2, ISOChronology.getInstanceUTC().yearOfCentury()),
    QUARTER(3, Joda.QuarterOfYear.getField((Chronology)ISOChronology.getInstanceUTC())),
    MONTH_OF_YEAR(4, ISOChronology.getInstanceUTC().monthOfYear()),
    DAY_OF_MONTH(5, ISOChronology.getInstanceUTC().dayOfMonth()),
    HOUR_OF_DAY(6, ISOChronology.getInstanceUTC().hourOfDay()),
    MINUTES_OF_HOUR(7, ISOChronology.getInstanceUTC().minuteOfHour()),
    SECOND_OF_MINUTE(8, ISOChronology.getInstanceUTC().secondOfMinute());

    private final byte id;
    private final DateTimeField field;

    private DateTimeUnit(byte id, DateTimeField field) {
        this.id = id;
        this.field = field;
    }

    public byte id() {
        return this.id;
    }

    public DateTimeField field() {
        return this.field;
    }

    public static DateTimeUnit resolve(byte id) {
        switch (id) {
            case 1: {
                return WEEK_OF_WEEKYEAR;
            }
            case 2: {
                return YEAR_OF_CENTURY;
            }
            case 3: {
                return QUARTER;
            }
            case 4: {
                return MONTH_OF_YEAR;
            }
            case 5: {
                return DAY_OF_MONTH;
            }
            case 6: {
                return HOUR_OF_DAY;
            }
            case 7: {
                return MINUTES_OF_HOUR;
            }
            case 8: {
                return SECOND_OF_MINUTE;
            }
        }
        throw new ElasticsearchException("Unknown date time unit id [" + id + "]", new Object[0]);
    }
}

