/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsThreadPoolExecutor
extends ThreadPoolExecutor {
    private volatile ShutdownListener listener;
    private final Object monitor = new Object();
    private final String name;

    EsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new EsAbortPolicy());
    }

    EsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, XRejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ShutdownListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.listener != null) {
                throw new IllegalStateException("Shutdown was already called on this thread pool");
            }
            if (this.isTerminated()) {
                listener.onTerminated();
            } else {
                this.listener = listener;
            }
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void terminated() {
        super.terminated();
        Object object = this.monitor;
        synchronized (object) {
            if (this.listener != null) {
                try {
                    this.listener.onTerminated();
                }
                finally {
                    this.listener = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        try {
            super.execute(command);
        }
        catch (EsRejectedExecutionException ex) {
            if (command instanceof AbstractRunnable) {
                try {
                    ((AbstractRunnable)command).onRejection(ex);
                }
                finally {
                    ((AbstractRunnable)command).onAfter();
                }
            }
            throw ex;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append('[');
        b.append(this.name).append(", ");
        if (this.getQueue() instanceof SizeBlockingQueue) {
            SizeBlockingQueue queue = (SizeBlockingQueue)this.getQueue();
            b.append("queue capacity = ").append(queue.capacity()).append(", ");
        }
        b.append(super.toString()).append(']');
        return b.toString();
    }

    public static interface ShutdownListener {
        public void onTerminated();
    }
}

