/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.IndexSearcherWrappingService;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.shard.MergeSchedulerConfig;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private final TranslogRecoveryPerformer translogRecoveryPerformer;
    private final Settings indexSettings;
    private volatile ByteSizeValue indexingBufferSize;
    private volatile ByteSizeValue versionMapSize;
    private volatile String versionMapSizeSetting;
    private volatile boolean compoundOnFlush = true;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private volatile boolean enableGcDeletes = true;
    private final String codecName;
    private final boolean optimizeAutoGenerateId;
    private final ThreadPool threadPool;
    private final ShardIndexingService indexingService;
    @Nullable
    private final IndicesWarmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final MergePolicy mergePolicy;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecService codecService;
    private final Engine.FailedEngineListener failedEngineListener;
    private final boolean forceNewTranslog;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    private final IndexSearcherWrappingService wrappingService;
    public static final String INDEX_COMPOUND_ON_FLUSH = "index.compound_on_flush";
    public static final String INDEX_OPTIMIZE_AUTOGENERATED_ID_SETTING = "index.optimize_auto_generated_id";
    public static final String INDEX_GC_DELETES_SETTING = "index.gc_deletes";
    public static final String INDEX_CODEC_SETTING = "index.codec";
    public static final String INDEX_VERSION_MAP_SIZE = "index.version_map_size";
    public static final String INDEX_FORCE_NEW_TRANSLOG = "index.engine.force_new_translog";
    public static final TimeValue DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
    public static final TimeValue DEFAULT_GC_DELETES = TimeValue.timeValueSeconds(60L);
    public static final String DEFAULT_VERSION_MAP_SIZE = "25%";
    private static final String DEFAULT_CODEC_NAME = "default";
    private TranslogConfig translogConfig;
    private boolean create = false;

    public EngineConfig(ShardId shardId, ThreadPool threadPool, ShardIndexingService indexingService, Settings indexSettings, IndicesWarmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, MergePolicy mergePolicy, MergeSchedulerConfig mergeSchedulerConfig, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.FailedEngineListener failedEngineListener, TranslogRecoveryPerformer translogRecoveryPerformer, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, IndexSearcherWrappingService wrappingService, TranslogConfig translogConfig) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.threadPool = threadPool;
        this.indexingService = indexingService;
        this.warmer = warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.mergePolicy = mergePolicy;
        this.mergeSchedulerConfig = mergeSchedulerConfig;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.codecService = codecService;
        this.failedEngineListener = failedEngineListener;
        this.wrappingService = wrappingService;
        this.optimizeAutoGenerateId = indexSettings.getAsBoolean(INDEX_OPTIMIZE_AUTOGENERATED_ID_SETTING, (Boolean)false);
        this.compoundOnFlush = indexSettings.getAsBoolean(INDEX_COMPOUND_ON_FLUSH, (Boolean)this.compoundOnFlush);
        this.codecName = indexSettings.get(INDEX_CODEC_SETTING, DEFAULT_CODEC_NAME);
        this.indexingBufferSize = IndexingMemoryController.INACTIVE_SHARD_INDEXING_BUFFER;
        this.gcDeletesInMillis = indexSettings.getAsTime(INDEX_GC_DELETES_SETTING, DEFAULT_GC_DELETES).millis();
        this.versionMapSizeSetting = indexSettings.get(INDEX_VERSION_MAP_SIZE, DEFAULT_VERSION_MAP_SIZE);
        this.updateVersionMapSize();
        this.translogRecoveryPerformer = translogRecoveryPerformer;
        this.forceNewTranslog = indexSettings.getAsBoolean(INDEX_FORCE_NEW_TRANSLOG, (Boolean)false);
        this.queryCache = queryCache;
        this.queryCachingPolicy = queryCachingPolicy;
        this.translogConfig = translogConfig;
    }

    private void updateVersionMapSize() {
        if (this.versionMapSizeSetting.endsWith("%")) {
            double percent = Double.parseDouble(this.versionMapSizeSetting.substring(0, this.versionMapSizeSetting.length() - 1));
            this.versionMapSize = new ByteSizeValue((long)((double)this.indexingBufferSize.bytes() * (percent / 100.0)));
        } else {
            this.versionMapSize = ByteSizeValue.parseBytesSizeValue(this.versionMapSizeSetting, INDEX_VERSION_MAP_SIZE);
        }
    }

    public void setVersionMapSizeSetting(String versionMapSizeSetting) {
        this.versionMapSizeSetting = versionMapSizeSetting;
        this.updateVersionMapSize();
    }

    public String getVersionMapSizeSetting() {
        return this.versionMapSizeSetting;
    }

    public boolean forceNewTranslog() {
        return this.forceNewTranslog;
    }

    public ByteSizeValue getVersionMapSize() {
        return this.versionMapSize;
    }

    public void setIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        this.indexingBufferSize = indexingBufferSize;
        this.updateVersionMapSize();
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isCompoundOnFlush() {
        return this.compoundOnFlush;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public boolean isOptimizeAutoGenerateId() {
        return this.optimizeAutoGenerateId;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public ShardIndexingService getIndexingService() {
        return this.indexingService;
    }

    @Nullable
    public IndicesWarmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public SnapshotDeletionPolicy getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public MergeSchedulerConfig getMergeSchedulerConfig() {
        return this.mergeSchedulerConfig;
    }

    public Engine.FailedEngineListener getFailedEngineListener() {
        return this.failedEngineListener;
    }

    public Settings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setGcDeletesInMillis(long gcDeletesInMillis) {
        this.gcDeletesInMillis = gcDeletesInMillis;
    }

    public void setCompoundOnFlush(boolean compoundOnFlush) {
        this.compoundOnFlush = compoundOnFlush;
    }

    public TranslogRecoveryPerformer getTranslogRecoveryPerformer() {
        return this.translogRecoveryPerformer;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public IndexSearcherWrappingService getWrappingService() {
        return this.wrappingService;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isCreate() {
        return this.create;
    }
}

