/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.rest.RestStatus;

public class QueryParsingException
extends ElasticsearchException {
    static final int UNKNOWN_POSITION = -1;
    private final int lineNumber;
    private final int columnNumber;

    public QueryParsingException(QueryParseContext parseContext, String msg, Object ... args) {
        this(parseContext, msg, null, args);
    }

    public QueryParsingException(QueryParseContext parseContext, String msg, Throwable cause, Object ... args) {
        super(msg, cause, args);
        XContentLocation location;
        this.setIndex(parseContext.index());
        int lineNumber = -1;
        int columnNumber = -1;
        XContentParser parser = parseContext.parser();
        if (parser != null && (location = parser.getTokenLocation()) != null) {
            lineNumber = location.lineNumber;
            columnNumber = location.columnNumber;
        }
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    public QueryParsingException(Index index, int line, int col, String msg, Throwable cause) {
        super(msg, cause, new Object[0]);
        this.setIndex(index);
        this.lineNumber = line;
        this.columnNumber = col;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    @Override
    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.lineNumber != -1) {
            builder.field("line", this.lineNumber);
            builder.field("col", this.columnNumber);
        }
        super.innerToXContent(builder, params);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.lineNumber);
        out.writeInt(this.columnNumber);
    }

    public QueryParsingException(StreamInput in) throws IOException {
        super(in);
        this.lineNumber = in.readInt();
        this.columnNumber = in.readInt();
    }
}

