/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWithinQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanWithinQueryParser
implements QueryParser {
    public static final String NAME = "span_within";

    @Inject
    public SpanWithinQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        SpanWithinQuery query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String queryName = null;
        SpanQuery big = null;
        SpanQuery little = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("big".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext, "span_within [big] must be of type span query", new Object[0]);
                    }
                    big = (SpanQuery)query;
                    continue;
                }
                if ("little".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext, "span_within [little] must be of type span query", new Object[0]);
                    }
                    little = (SpanQuery)query;
                    continue;
                }
                throw new QueryParsingException(parseContext, "[span_within] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[span_within] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (big == null) {
            throw new QueryParsingException(parseContext, "span_within must include [big]", new Object[0]);
        }
        if (little == null) {
            throw new QueryParsingException(parseContext, "span_within must include [little]", new Object[0]);
        }
        query = new SpanWithinQuery(big, little);
        if (boost != 1.0f) {
            query.setBoost(boost);
        }
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)query);
        }
        return query;
    }
}

