/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucket;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalPercentilesBucket
extends InternalNumericMetricsAggregation.MultiValue
implements PercentilesBucket {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles_bucket");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalPercentilesBucket readResult(StreamInput in) throws IOException {
            InternalPercentilesBucket result = new InternalPercentilesBucket();
            result.readFrom(in);
            return result;
        }
    };
    private double[] percentiles;
    private double[] percents;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    protected InternalPercentilesBucket() {
    }

    public InternalPercentilesBucket(String name, double[] percents, double[] percentiles, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.valueFormatter = formatter;
        this.percentiles = percentiles;
        this.percents = percents;
    }

    @Override
    public double percentile(double percent) throws IllegalArgumentException {
        int index = Arrays.binarySearch(this.percents, percent);
        if (index < 0) {
            throw new IllegalArgumentException("Percent requested [" + String.valueOf(percent) + "] was not" + " one of the computed percentiles.  Available keys are: " + Arrays.toString(this.percents));
        }
        return this.percentiles[index];
    }

    @Override
    public String percentileAsString(double percent) {
        return this.valueFormatter.format(this.percentile(percent));
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.percents, this.percentiles);
    }

    @Override
    public double value(String name) {
        return this.percentile(Double.parseDouble(name));
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalMax doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.percentiles = in.readDoubleArray();
        this.percents = in.readDoubleArray();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDoubleArray(this.percentiles);
        out.writeDoubleArray(this.percents);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("values");
        for (double percent : this.percents) {
            double value = this.percentile(percent);
            boolean hasValue = !Double.isInfinite(value) && !Double.isNaN(value);
            String key = String.valueOf(percent);
            builder.field(key, hasValue ? Double.valueOf(value) : null);
            if (!hasValue || this.valueFormatter instanceof ValueFormatter.Raw) continue;
            builder.field(key + "_as_string", this.percentileAsString(percent));
        }
        builder.endObject();
        return builder;
    }

    public static class Iter
    extends UnmodifiableIterator<Percentile> {
        private final double[] percents;
        private final double[] percentiles;
        private int i;

        public Iter(double[] percents, double[] percentiles) {
            this.percents = percents;
            this.percentiles = percentiles;
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        public Percentile next() {
            InternalPercentile next = new InternalPercentile(this.percents[this.i], this.percentiles[this.i]);
            ++this.i;
            return next;
        }
    }
}

