/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;

public class DfsPhase
implements SearchPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        ObjectHashSet termsSet = new ObjectHashSet();
        try {
            context.searcher().createNormalizedWeight(context.query(), true).extractTerms((Set)new DelegateSet(termsSet));
            for (RescoreSearchContext rescoreContext : context.rescore()) {
                rescoreContext.rescorer().extractTerms(context, rescoreContext, new DelegateSet(termsSet));
            }
            Term[] terms = (Term[])termsSet.toArray(Term.class);
            TermStatistics[] termStatistics = new TermStatistics[terms.length];
            IndexReaderContext indexReaderContext = context.searcher().getTopReaderContext();
            for (int i = 0; i < terms.length; ++i) {
                TermContext termContext = TermContext.build((IndexReaderContext)indexReaderContext, (Term)terms[i]);
                termStatistics[i] = context.searcher().termStatistics(terms[i], termContext);
            }
            ObjectObjectHashMap fieldStatistics = HppcMaps.newNoNullKeysMap();
            for (Term term : terms) {
                assert (term.field() != null) : "field is null";
                if (fieldStatistics.containsKey((Object)term.field())) continue;
                CollectionStatistics collectionStatistics = context.searcher().collectionStatistics(term.field());
                fieldStatistics.put((Object)term.field(), (Object)collectionStatistics);
            }
            context.dfsResult().termsStatistics(terms, termStatistics).fieldStatistics(fieldStatistics).maxDoc(context.searcher().getIndexReader().maxDoc());
        }
        catch (Exception e) {
            throw new DfsPhaseExecutionException(context, "Exception during dfs phase", (Throwable)e);
        }
        finally {
            termsSet.clear();
        }
    }

    private static class DelegateSet
    extends AbstractSet<Term> {
        private final ObjectHashSet<Term> delegate;

        private DelegateSet(ObjectHashSet<Term> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean add(Term term) {
            return this.delegate.add((Object)term);
        }

        @Override
        public boolean addAll(Collection<? extends Term> terms) {
            boolean result = false;
            for (Term term : terms) {
                result = this.delegate.add((Object)term);
            }
            return result;
        }

        @Override
        public Iterator<Term> iterator() {
            final Iterator iterator = this.delegate.iterator();
            return new Iterator<Term>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Term next() {
                    return (Term)((ObjectCursor)iterator.next()).value;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

