/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;

abstract class ConvTableBidiMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    char[] toUnicode_ = null;
    byte[] fromUnicode_ = null;

    ConvTableBidiMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.ccsid_ = n;
        this.toUnicode_ = cArray;
        if (Trace.traceOn_) {
            Trace.log(5, "Decompressing bidi single-byte conversion table for ccsid: " + this.ccsid_, cArray2.length);
        }
        this.fromUnicode_ = this.decompressSB(cArray2, (byte)63);
        this.bidiStringType_ = AS400BidiTransform.getStringType(n);
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded bidi single-byte map for ccsid: " + this.ccsid_);
        }
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        int n3 = bidiConversionProperties.getBidiStringType();
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi String Type: " + n3);
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        while (n4 < n2) {
            cArray[n4] = this.toUnicode_[0xFF & byArray[n + n4++]];
        }
        if (n3 == -1) {
            if (Trace.traceOn_) {
                Trace.log(5, "Destination string (no java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
            }
            return String.copyValueOf(cArray);
        }
        AS400BidiTransform aS400BidiTransform = new AS400BidiTransform(this.ccsid_);
        if (n3 == 0 && this.bidiStringType_ != 0) {
            bidiConversionProperties.setBidiStringType(this.bidiStringType_);
        }
        aS400BidiTransform.setBidiConversionProperties(bidiConversionProperties);
        if (Trace.traceOn_) {
            Trace.log(5, "Destination string (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        String string = aS400BidiTransform.toJavaLayout(String.copyValueOf(cArray));
        if (Trace.traceOn_) {
            Trace.log(5, "Destination string (after java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(string.toCharArray()));
        }
        return string;
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        Object object;
        int n = bidiConversionProperties.getBidiStringType();
        char[] cArray = null;
        if (n == -1) {
            cArray = string.toCharArray();
            if (Trace.traceOn_) {
                Trace.log(5, "Converting string to byte array (no layout applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
            }
        } else {
            object = new AS400BidiTransform(this.ccsid_);
            if (n == 0 && this.bidiStringType_ != 0) {
                bidiConversionProperties.setBidiStringType(this.bidiStringType_);
            }
            ((AS400BidiTransform)object).setBidiConversionProperties(bidiConversionProperties);
            if (Trace.traceOn_) {
                Trace.log(5, "Bidi String Type: " + n);
                Trace.log(5, "Converting string to byte array (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(string.toCharArray()));
            }
            cArray = ((AS400BidiTransform)object).toAS400Layout(string).toCharArray();
            if (Trace.traceOn_) {
                Trace.log(5, "Converting string to byte array (after java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
            }
        }
        object = new byte[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            object[n2] = this.fromUnicode_[cArray[n2++]];
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, (byte[])object);
        }
        return object;
    }
}

