/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessRoot
extends PermissionAccess {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    public PermissionAccessRoot(AS400 aS400) {
        super(aS400);
    }

    public void addUser(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessRoot.getChgCommand(this.as400_, string, userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    protected final String expandQuotes(String string) {
        return PermissionAccessRoot.expandQuotes0(string);
    }

    static String expandQuotes0(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.indexOf(39) != -1 || string.indexOf(34) != -1) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (stringBuffer.charAt(i) == '\'') {
                    stringBuffer.insert(i, '\'');
                    continue;
                }
                if (stringBuffer.charAt(i) != '\"') continue;
                stringBuffer.insert(i, '\"');
            }
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
        }
        stringBuffer.insert(0, '\'');
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    private static CommandCall getChgCommand(AS400 aS400, String string, UserPermission userPermission) {
        RootPermission rootPermission = (RootPermission)userPermission;
        String string2 = rootPermission.getUserID();
        String string3 = rootPermission.getDataAuthority();
        boolean bl = rootPermission.isManagement();
        boolean bl2 = rootPermission.isExistence();
        boolean bl3 = rootPermission.isAlter();
        boolean bl4 = rootPermission.isReference();
        String string4 = "";
        if (bl) {
            string4 = string4 + "*OBJMGT ";
        }
        if (bl2) {
            string4 = string4 + "*OBJEXIST ";
        }
        if (bl3) {
            string4 = string4 + "*OBJALTER ";
        }
        if (bl4) {
            string4 = string4 + "*OBJREF";
        }
        if (!(bl || bl2 || bl3 || bl4)) {
            string4 = "*NONE";
            if (string3.equals("*NONE")) {
                string3 = "*EXCLUDE";
            }
        }
        String string5 = "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(string) + ")" + " USER(" + string2 + ")" + " DTAAUT(" + string3 + ")" + " OBJAUT(" + string4 + ")";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    private static CommandCall getRmvCommand(AS400 aS400, String string, String string2) {
        String string3 = "*NONE";
        String string4 = "*NONE";
        String string5 = "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(string) + ")" + " USER(" + string2 + ")" + " DTAAUT(" + string3 + ")" + " OBJAUT(" + string4 + ")";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    public UserPermission getUserPermission(Record record) throws UnsupportedEncodingException {
        String string = ((String)record.getField("profileName")).trim();
        String string2 = ((String)record.getField("userOrGroup")).trim();
        String string3 = ((String)record.getField("dataAuthority")).trim();
        String string4 = ((String)record.getField("autListMgt")).trim();
        String string5 = ((String)record.getField("objMgt")).trim();
        String string6 = ((String)record.getField("objExistence")).trim();
        String string7 = ((String)record.getField("objAlter")).trim();
        String string8 = ((String)record.getField("objRef")).trim();
        RootPermission rootPermission = new RootPermission(string);
        rootPermission.setGroupIndicator(this.getIntValue(string2));
        rootPermission.setAuthorizationListManagement(this.getBooleanValue(string4));
        rootPermission.setManagement(this.getBooleanValue(string5));
        rootPermission.setExistence(this.getBooleanValue(string6));
        rootPermission.setAlter(this.getBooleanValue(string7));
        rootPermission.setReference(this.getBooleanValue(string8));
        if (string3.toUpperCase().equals("*AUTL")) {
            rootPermission.setDataAuthority("*EXCLUDE");
            rootPermission.setFromAuthorizationList(true);
        } else {
            rootPermission.setDataAuthority(string3);
        }
        return rootPermission;
    }

    public void removeUser(String string, String string2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessRoot.getRmvCommand(this.as400_, string, string2);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthority(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessRoot.getChgCommand(this.as400_, string, userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthorizationList(String string, String string2, String string3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = new CommandCall(this.as400_);
        String string4 = "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(string) + ")" + " AUTL(" + string2 + ")";
        commandCall.setCommand(string4);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setFromAuthorizationList(String string, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = new CommandCall(this.as400_);
        String string2 = bl ? "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(string) + ")" + " USER(*PUBLIC)" + " DTAAUT(*AUTL)" + " OBJAUT(*NONE)" : "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(string) + ")" + " USER(*PUBLIC)" + " DTAAUT(*EXCLUDE)" + " OBJAUT(*NONE)";
        commandCall.setCommand(string2);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setSensitivity(String string, int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
    }
}

