/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

abstract class PrintObjectImplRemote
implements PrintObjectImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    NPCPAttribute attrs;
    private AS400ImplRemote system_;
    private NPCPID cpID_;
    private int objectType_;

    PrintObjectImplRemote() {
    }

    void checkRunTimeState() {
        if (this.getSystem() == null) {
            Trace.log(2, "Parameter 'system' has not been set.");
            throw new ExtendedIllegalStateException("system", 4);
        }
    }

    abstract NPCPAttributeIDList getAttrIDsToRetrieve();

    abstract NPCPAttributeIDList getAttrIDsToRetrieve(int var1);

    public NPCPAttribute getAttrValue() {
        return this.attrs;
    }

    final NPCPID getIDCodePoint() {
        return this.cpID_;
    }

    public Integer getIntegerAttribute(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        Integer n2 = null;
        if (this.attrs != null) {
            n2 = this.attrs.getIntValue(n);
        }
        if (n2 == null && (n2 = this.getIDCodePoint().getIntValue(n)) == null) {
            object = this.getAttrIDsToRetrieve();
            if (((NPCPAttributeIDList)object).containsID(n)) {
                this.updateAttrs((NPCPAttributeIDList)object);
                if (this.attrs != null) {
                    n2 = this.attrs.getIntValue(n);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + n + " requested but not in attrIDsToRetreive list.");
            }
        }
        if (n2 == null) {
            object = NPSystem.getSystem(this.getSystem());
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            String string = nPConversation.getAttribute(141);
            ((NPSystem)object).returnConversation(nPConversation);
            throw new RequestNotSupportedException(string, 1);
        }
        return n2;
    }

    public Integer getSingleIntegerAttribute(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        Integer n2 = null;
        if (this.attrs != null) {
            n2 = this.attrs.getIntValue(n);
        }
        if (n2 == null && (n2 = this.getIDCodePoint().getIntValue(n)) == null) {
            object = this.getAttrIDsToRetrieve(n);
            if (((NPCPAttributeIDList)object).containsID(n)) {
                this.updateAttrs((NPCPAttributeIDList)object);
                if (this.attrs != null) {
                    n2 = this.attrs.getIntValue(n);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + n + " requested but not in attrIDsToRetreive list.");
            }
        }
        if (n2 == null) {
            object = NPSystem.getSystem(this.getSystem());
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            String string = nPConversation.getAttribute(141);
            ((NPSystem)object).returnConversation(nPConversation);
            throw new RequestNotSupportedException(string, 1);
        }
        return n2;
    }

    public Float getSingleFloatAttribute(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        Float f = null;
        if (this.attrs != null) {
            f = this.attrs.getFloatValue(n);
        }
        if (f == null && (f = this.getIDCodePoint().getFloatValue(n)) == null) {
            object = this.getAttrIDsToRetrieve(n);
            if (((NPCPAttributeIDList)object).containsID(n)) {
                this.updateAttrs((NPCPAttributeIDList)object);
                if (this.attrs != null) {
                    f = this.attrs.getFloatValue(n);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + n + " requested but not in attrIDsToRetreive list.");
            }
        }
        if (f == null) {
            object = NPSystem.getSystem(this.getSystem());
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            String string = nPConversation.getAttribute(141);
            ((NPSystem)object).returnConversation(nPConversation);
            throw new RequestNotSupportedException(string, 1);
        }
        return f;
    }

    public String getSingleStringAttribute(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        String string = null;
        if (this.attrs != null) {
            string = this.attrs.getStringValue(n);
        }
        if (string == null && (string = this.getIDCodePoint().getStringValue(n)) == null) {
            object = this.getAttrIDsToRetrieve(n);
            if (((NPCPAttributeIDList)object).containsID(n)) {
                this.updateAttrs((NPCPAttributeIDList)object);
                if (this.attrs != null) {
                    string = this.attrs.getStringValue(n);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + n + " requested but not in attrIDsToRetreive list.");
            }
        }
        if (string == null) {
            object = NPSystem.getSystem(this.getSystem());
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            String string2 = nPConversation.getAttribute(141);
            ((NPSystem)object).returnConversation(nPConversation);
            throw new RequestNotSupportedException(string2, 1);
        }
        return string;
    }

    public Float getFloatAttribute(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        Float f = null;
        if (this.attrs != null) {
            f = this.attrs.getFloatValue(n);
        }
        if (f == null && (f = this.getIDCodePoint().getFloatValue(n)) == null) {
            object = this.getAttrIDsToRetrieve();
            if (((NPCPAttributeIDList)object).containsID(n)) {
                this.updateAttrs((NPCPAttributeIDList)object);
                if (this.attrs != null) {
                    f = this.attrs.getFloatValue(n);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + n + " requested but not in attrIDsToRetreive list.");
            }
        }
        if (f == null) {
            object = NPSystem.getSystem(this.getSystem());
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            String string = nPConversation.getAttribute(141);
            ((NPSystem)object).returnConversation(nPConversation);
            throw new RequestNotSupportedException(string, 1);
        }
        return f;
    }

    public String getStringAttribute(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Object object;
        String string = null;
        if (this.attrs != null) {
            string = this.attrs.getStringValue(n);
        }
        if (string == null && (string = this.getIDCodePoint().getStringValue(n)) == null) {
            object = this.getAttrIDsToRetrieve();
            if (((NPCPAttributeIDList)object).containsID(n)) {
                this.updateAttrs((NPCPAttributeIDList)object);
                if (this.attrs != null) {
                    string = this.attrs.getStringValue(n);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + n + " requested but not in attrIDsToRetreive list.");
            }
        }
        if (string == null) {
            object = NPSystem.getSystem(this.getSystem());
            NPConversation nPConversation = ((NPSystem)object).getConversation();
            String string2 = nPConversation.getAttribute(141);
            ((NPSystem)object).returnConversation(nPConversation);
            throw new RequestNotSupportedException(string2, 1);
        }
        return string;
    }

    public final AS400ImplRemote getSystem() {
        return this.system_;
    }

    final void setIDCodePoint(NPCPID nPCPID) {
        this.cpID_ = nPCPID;
    }

    public void setPrintObjectAttrs(NPCPID nPCPID, NPCPAttribute nPCPAttribute, int n) {
        block3: {
            this.cpID_ = nPCPID;
            this.attrs = nPCPAttribute;
            this.objectType_ = n;
            try {
                this.cpID_.setConverter(ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_));
                if (this.attrs != null) {
                    this.attrs.setConverter(ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!Trace.isTraceErrorOn()) break block3;
                Trace.log(2, "Error initializing converter for print object", (Throwable)unsupportedEncodingException);
            }
        }
    }

    public final void setSystem(AS400Impl aS400Impl) {
        this.system_ = (AS400ImplRemote)aS400Impl;
        this.attrs = null;
    }

    public void update() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    void updateAttrs(NPCPAttributeIDList nPCPAttributeIDList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPDataStream.setAction(15);
        nPDataStream.addCodePoint(this.getIDCodePoint());
        nPDataStream.addCodePoint(nPCPAttributeIDList);
        nPDataStream2.addCodePoint(nPCPAttribute);
        NPSystem nPSystem = NPSystem.getSystem(this.getSystem());
        if (nPSystem != null) {
            int n = nPSystem.makeRequest(nPDataStream, nPDataStream2);
            if (n == 0) {
                if (this.attrs != null) {
                    this.attrs.addUpdateAttributes(nPCPAttribute);
                } else {
                    this.attrs = nPCPAttribute;
                }
            } else {
                NPConversation nPConversation = nPSystem.getConversation();
                String string = nPConversation.getAttribute(141);
                nPSystem.returnConversation(nPConversation);
                switch (n) {
                    case 4: {
                        throw new RequestNotSupportedException(string, 1);
                    }
                }
            }
        }
    }
}

