/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import java.awt.BorderLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

class DoubleClickList
extends JComponent
implements ItemSelectable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    JList list_;
    JScrollPane scrollPane_;
    transient Vector itemListeners_;

    public DoubleClickList(String[] stringArray) {
        this.list_ = new JList<String>(stringArray);
        this.list_.setSelectionMode(0);
        this.scrollPane_ = new JScrollPane(this.list_);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane_);
        this.initializeTransient();
    }

    public DoubleClickList(ListModel listModel) {
        this.list_ = new JList(listModel);
        this.list_.setSelectionMode(0);
        this.scrollPane_ = new JScrollPane(this.list_);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane_);
        this.initializeTransient();
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            throw new NullPointerException("listener");
        }
        this.itemListeners_.addElement(itemListener);
    }

    public int getSelectedIndex() {
        return this.list_.getSelectedIndex();
    }

    public Object[] getSelectedObjects() {
        return this.list_.getSelectedValues();
    }

    private void initializeTransient() {
        this.itemListeners_ = new Vector();
        this.list_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object e;
                if (mouseEvent.getClickCount() > 1 && (e = DoubleClickList.this.list_.getSelectedValue()) != null && DoubleClickList.this.list_.isEnabled()) {
                    ItemEvent itemEvent = new ItemEvent(DoubleClickList.this, 701, e, 1);
                    Enumeration enumeration = DoubleClickList.this.itemListeners_.elements();
                    while (enumeration.hasMoreElements()) {
                        ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
                    }
                }
            }
        });
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            throw new NullPointerException("listener");
        }
        this.itemListeners_.removeElement(itemListener);
    }

    public void setEnabled(boolean bl) {
        this.list_.setEnabled(bl);
    }

    public void setListData(Object[] objectArray) {
        this.list_.setListData(objectArray);
    }

    public void setSelectedIndex(int n) {
        this.list_.setSelectedIndex(n);
    }

    public void setVisibleRowCount(int n) {
        this.list_.setVisibleRowCount(n);
    }
}

