/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.AtomicUtils;
import org.apache.hadoop.hbase.util.Counter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FastLongHistogram {
    public static final int DEFAULT_NBINS = 255;
    public static final double[] DEFAULT_QUANTILES = new double[]{0.25, 0.5, 0.75, 0.9, 0.95, 0.98, 0.99, 0.999};
    private volatile Bins bins;

    public FastLongHistogram() {
        this(255);
    }

    public FastLongHistogram(int numOfBins) {
        this.bins = new Bins(numOfBins);
    }

    public FastLongHistogram(int numOfBins, long min, long max) {
        this(numOfBins);
        Bins bins = new Bins(numOfBins);
        bins.add(min, 1L);
        bins.add(max, 1L);
        this.bins = new Bins(bins, numOfBins, 0.01, 0.999);
    }

    private FastLongHistogram(Bins bins) {
        this.bins = bins;
    }

    public void add(long value, long count) {
        this.bins.add(value, count);
    }

    public long[] getQuantiles(double[] quantiles) {
        return this.bins.getQuantiles(quantiles);
    }

    public long[] getQuantiles() {
        return this.bins.getQuantiles(DEFAULT_QUANTILES);
    }

    public long getMin() {
        return this.bins.min.get();
    }

    public long getMax() {
        return this.bins.max.get();
    }

    public long getCount() {
        return this.bins.count.get();
    }

    public long getMean() {
        Bins bins = this.bins;
        long count = bins.count.get();
        long total = bins.total.get();
        if (count == 0L) {
            return 0L;
        }
        return total / count;
    }

    public long getNumAtOrBelow(long value) {
        return this.bins.getNumAtOrBelow(value);
    }

    public FastLongHistogram reset() {
        Bins oldBins = this.bins;
        this.bins = new Bins(this.bins, this.bins.counts.length - 3, 0.01, 0.99);
        return new FastLongHistogram(oldBins);
    }

    private static class Bins {
        private final Counter[] counts;
        private final long binsMin;
        private final long binsMax;
        private final long bins10XMax;
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong max = new AtomicLong(0L);
        private final Counter count = new Counter(0L);
        private final Counter total = new Counter(0L);
        private final AtomicBoolean hasData = new AtomicBoolean(false);

        public Bins(int numBins) {
            this.counts = this.createCounters(numBins + 3);
            this.binsMin = 1L;
            this.binsMax = 1000L;
            this.bins10XMax = this.binsMax * 10L;
        }

        public Bins(Bins last, int numOfBins, double minQ, double maxQ) {
            long[] values = last.getQuantiles(new double[]{minQ, maxQ});
            long wd = values[1] - values[0] + 1L;
            this.binsMin = Math.max(0L, (long)((double)values[0] - (double)wd * minQ));
            long binsMax = (long)((double)values[1] + (double)wd * (1.0 - maxQ)) + 1L;
            this.binsMax = Math.max(binsMax, this.binsMin + (long)numOfBins);
            this.bins10XMax = Math.max(values[1] + (binsMax - 1L) * 9L, this.binsMax + 1L);
            this.counts = this.createCounters(numOfBins + 3);
        }

        private Counter[] createCounters(int num) {
            Counter[] counters = new Counter[num];
            for (int i = 0; i < num; ++i) {
                counters[i] = new Counter();
            }
            return counters;
        }

        private int getIndex(long value) {
            if (value < this.binsMin) {
                return 0;
            }
            if (value > this.bins10XMax) {
                return this.counts.length - 1;
            }
            if (value >= this.binsMax) {
                return this.counts.length - 2;
            }
            return 1 + (int)((value - this.binsMin) * (long)(this.counts.length - 3) / (this.binsMax - this.binsMin));
        }

        public void add(long value, long count) {
            if (value < 0L) {
                return;
            }
            AtomicUtils.updateMin(this.min, value);
            AtomicUtils.updateMax(this.max, value);
            this.count.add(count);
            this.total.add(value * count);
            int pos = this.getIndex(value);
            this.counts[pos].add(count);
            this.hasData.set(true);
        }

        public long[] getQuantiles(double[] quantiles) {
            if (!this.hasData.get()) {
                return new long[quantiles.length];
            }
            long[] counts = new long[this.counts.length];
            long total = 0L;
            for (int i = 0; i < this.counts.length; ++i) {
                counts[i] = this.counts[i].get();
                total += counts[i];
            }
            int rIndex = 0;
            double qCount = (double)total * quantiles[0];
            long cum = 0L;
            long[] res = new long[quantiles.length];
            block1: for (int i = 0; i < counts.length; ++i) {
                long mx;
                long mn;
                if (i == 0) {
                    mn = this.min.get();
                    mx = this.binsMin;
                } else if (i == counts.length - 1) {
                    mn = this.bins10XMax;
                    mx = this.max.get();
                } else if (i == counts.length - 2) {
                    mn = this.binsMax;
                    mx = this.bins10XMax;
                } else {
                    mn = this.binsMin + (long)(i - 1) * (this.binsMax - this.binsMin) / (long)(this.counts.length - 3);
                    mx = this.binsMin + (long)i * (this.binsMax - this.binsMin) / (long)(this.counts.length - 3);
                }
                if (mx < this.min.get()) continue;
                if (mn > this.max.get()) break;
                mn = Math.max(mn, this.min.get());
                mx = Math.min(mx, this.max.get());
                double lastCum = cum;
                cum += counts[i];
                while (qCount <= (double)cum) {
                    res[rIndex] = (double)cum == lastCum ? mn : (long)((qCount - lastCum) * (double)(mx - mn) / ((double)cum - lastCum) + (double)mn);
                    if (++rIndex >= quantiles.length) break block1;
                    qCount = (double)total * quantiles[rIndex];
                }
            }
            while (rIndex < quantiles.length) {
                res[rIndex] = this.max.get();
                ++rIndex;
            }
            return res;
        }

        long getNumAtOrBelow(long val) {
            int targetIndex = this.getIndex(val);
            long totalToCurrentIndex = 0L;
            for (int i = 0; i <= targetIndex; ++i) {
                totalToCurrentIndex += this.counts[i].get();
            }
            return totalToCurrentIndex;
        }
    }
}

