/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.repository.importexport;

import com.pentaho.repository.importexport.PDIImportUtil;
import com.pentaho.repository.importexport.StreamToJobNodeConverter;
import com.pentaho.repository.importexport.StreamToTransNodeConverter;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.util.IPdiContentProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PdiContentProvider
implements IPdiContentProvider {
    private Log log = LogFactory.getLog(PdiContentProvider.class);
    IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);

    public boolean hasUserParameters(String kettleFilePath) {
        RepositoryFile file;
        if (!StringUtils.isEmpty((String)kettleFilePath) && (file = this.unifiedRepository.getFile(kettleFilePath)) != null) {
            try {
                return this.hasUserParameters(this.getMeta(file));
            }
            catch (KettleException e) {
                this.log.error((Object)e);
            }
        }
        return false;
    }

    public String[] getUserParameters(String kettleFilePath) {
        RepositoryFile file;
        ArrayList userParams = new ArrayList();
        if (!StringUtils.isEmpty((String)kettleFilePath) && (file = this.unifiedRepository.getFile(kettleFilePath)) != null) {
            try {
                NamedParams np = this.getMeta(file);
                np = this.filterUserParameters(np);
                if (!this.isEmpty(np)) {
                    return np.listParameters();
                }
            }
            catch (KettleException e) {
                this.log.error((Object)e);
            }
        }
        return userParams.toArray(new String[0]);
    }

    private NamedParams filterUserParameters(NamedParams params) {
        NamedParamsDefault userParams = new NamedParamsDefault();
        if (!this.isEmpty(params)) {
            for (String paramName : params.listParameters()) {
                if (!this.isUserParameter(paramName)) continue;
                try {
                    userParams.addParameterDefinition(paramName, "", "");
                }
                catch (DuplicateParamException duplicateParamException) {
                    // empty catch block
                }
            }
        }
        return userParams;
    }

    private NamedParams getMeta(RepositoryFile file) throws KettleException {
        TransMeta meta = null;
        if (file != null) {
            String extension = FilenameUtils.getExtension((String)file.getName());
            Repository repo = PDIImportUtil.connectToRepository(null);
            if ("ktr".equalsIgnoreCase(extension)) {
                meta = new TransMeta(this.convertTransformation(file.getId()), repo, true, null, null);
            } else if ("kjb".equalsIgnoreCase(extension)) {
                meta = new JobMeta(this.convertJob(file.getId()), repo, null);
            }
        }
        return meta;
    }

    private InputStream convertTransformation(Serializable fileId) {
        return new StreamToTransNodeConverter(this.unifiedRepository).convert(fileId);
    }

    private InputStream convertJob(Serializable fileId) {
        return new StreamToJobNodeConverter(this.unifiedRepository).convert(fileId);
    }

    private boolean isUserParameter(String paramName) {
        return StringUtils.isEmpty((String)paramName) || !paramName.startsWith("_");
    }

    private boolean hasUserParameters(NamedParams params) {
        return !this.isEmpty(this.filterUserParameters(params));
    }

    private boolean isEmpty(NamedParams np) {
        return np == null || np.listParameters() == null || np.listParameters().length == 0;
    }
}

