/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;

public class AttributesMapUtil {
    public static final String NODE_ATTRIBUTE_GROUPS = "ATTRIBUTE_GROUPS";

    public static final void saveAttributesMap(DataNode dataNode, AttributesInterface attributesInterface) throws KettleException {
        Map attributesMap = attributesInterface.getAttributesMap();
        DataNode attributeNodes = dataNode.getNode(NODE_ATTRIBUTE_GROUPS);
        if (attributeNodes == null) {
            attributeNodes = dataNode.addNode(NODE_ATTRIBUTE_GROUPS);
        }
        for (String groupName : attributesMap.keySet()) {
            DataNode attributeNode = attributeNodes.getNode(groupName);
            if (attributeNode == null) {
                attributeNode = attributeNodes.addNode(groupName);
            }
            Map attributes = (Map)attributesMap.get(groupName);
            for (String key : attributes.keySet()) {
                String value = (String)attributes.get(key);
                if (key == null || value == null) continue;
                attributeNode.setProperty(key, (String)attributes.get(key));
            }
        }
    }

    public static final void loadAttributesMap(DataNode dataNode, AttributesInterface attributesInterface) throws KettleException {
        HashMap attributesMap = new HashMap();
        attributesInterface.setAttributesMap(attributesMap);
        DataNode groupsNode = dataNode.getNode(NODE_ATTRIBUTE_GROUPS);
        if (groupsNode != null) {
            Iterable nodes = groupsNode.getNodes();
            for (DataNode groupNode : nodes) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributesMap.put(groupNode.getName(), attributes);
                Iterable properties = groupNode.getProperties();
                for (DataProperty dataProperty : properties) {
                    String key = dataProperty.getName();
                    String value = dataProperty.getString();
                    if (key == null || value == null) continue;
                    attributes.put(key, value);
                }
            }
        }
    }
}

