/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.model.IEEUser;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.platform.api.engine.security.userroledao.UserRoleInfo;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoRole;
import org.pentaho.platform.security.userroledao.ws.ProxyPentahoUser;
import org.pentaho.platform.security.userroledao.ws.UserRoleSecurityInfo;

public class UserRoleLookupCache
implements Serializable {
    private static final long serialVersionUID = -5922614423981595812L;
    Set<IUser> userInfoSet;
    Set<IRole> roleInfoSet;
    IRoleSupportSecurityManager rsm;

    public UserRoleLookupCache(UserRoleInfo userRoleInfo, IRoleSupportSecurityManager rsm) {
        this.rsm = rsm;
        this.userInfoSet = new HashSet<IUser>();
        for (String user : userRoleInfo.getUsers()) {
            this.userInfoSet.add(this.createUserInfo(user));
        }
        this.roleInfoSet = new HashSet<IRole>();
        for (String role : userRoleInfo.getRoles()) {
            this.roleInfoSet.add(this.createRoleInfo(role));
        }
    }

    public UserRoleLookupCache(UserRoleSecurityInfo userRoleSecurityInfo, IRoleSupportSecurityManager rsm) {
        this.rsm = rsm;
        this.userInfoSet = new HashSet<IUser>();
        for (ProxyPentahoUser user : userRoleSecurityInfo.getUsers()) {
            this.userInfoSet.add(this.createUserInfo(user));
        }
        this.roleInfoSet = new HashSet<IRole>();
        for (ProxyPentahoRole role : userRoleSecurityInfo.getRoles()) {
            this.roleInfoSet.add(this.createRoleInfo(role));
        }
    }

    public IUser lookupUser(ProxyPentahoUser proxyUser) {
        for (IUser user : this.userInfoSet) {
            if (!user.getLogin().equals(proxyUser.getName())) continue;
            return user;
        }
        return this.addUserToLookupSet(proxyUser);
    }

    public IRole lookupRole(ProxyPentahoRole proxyRole) {
        for (IRole role : this.roleInfoSet) {
            if (!role.getName().equals(proxyRole.getName())) continue;
            return role;
        }
        return this.addRoleToLookupSet(proxyRole);
    }

    public void insertUserToLookupSet(IUser user) {
        this.userInfoSet.add(user);
    }

    public void insertRoleToLookupSet(IRole role) {
        this.roleInfoSet.add(role);
    }

    public void updateUserInLookupSet(IUser user) {
        IUser userInfoToUpdate = null;
        for (IUser userInfo : this.userInfoSet) {
            if (!userInfo.getLogin().equals(user.getLogin())) continue;
            userInfoToUpdate = userInfo;
            break;
        }
        userInfoToUpdate.setDescription(user.getDescription());
        if (!StringUtils.isEmpty((String)user.getPassword())) {
            userInfoToUpdate.setPassword(user.getPassword());
        }
        if (user instanceof IEEUser) {
            ((IEEUser)userInfoToUpdate).setRoles(((IEEUser)user).getRoles());
        }
    }

    public void updateRoleInLookupSet(IRole role) {
        IRole roleInfoToUpdate = null;
        for (IRole roleInfo : this.roleInfoSet) {
            if (!roleInfo.getName().equals(role.getName())) continue;
            roleInfoToUpdate = roleInfo;
            break;
        }
        roleInfoToUpdate.setDescription(role.getDescription());
        roleInfoToUpdate.setUsers(role.getUsers());
    }

    public void removeUsersFromLookupSet(List<IUser> users) {
        for (IUser user : users) {
            this.removeUserFromLookupSet(user);
        }
    }

    public void removeRolesFromLookupSet(List<IRole> roles) {
        for (IRole role : roles) {
            this.removeRoleFromLookupSet(role);
        }
    }

    private void removeUserFromLookupSet(IUser user) {
        IUser userToRemove = null;
        for (IUser userInfo : this.userInfoSet) {
            if (userInfo.getLogin().equals(user.getLogin())) {
                userToRemove = userInfo;
                break;
            }
            this.userInfoSet.remove(userToRemove);
        }
    }

    private void removeRoleFromLookupSet(IRole role) {
        IRole roleToRemove = null;
        for (IRole roleInfo : this.roleInfoSet) {
            if (roleInfo.getName().equals(role.getName())) {
                roleToRemove = roleInfo;
                break;
            }
            this.roleInfoSet.remove(roleToRemove);
        }
    }

    private IUser addUserToLookupSet(ProxyPentahoUser user) {
        IUser userInfo = this.createUserInfo(user);
        this.userInfoSet.add(userInfo);
        return userInfo;
    }

    private IRole addRoleToLookupSet(ProxyPentahoRole role) {
        IRole roleInfo = this.createRoleInfo(role);
        this.roleInfoSet.add(roleInfo);
        return roleInfo;
    }

    private IUser createUserInfo(ProxyPentahoUser user) {
        IUser userInfo = null;
        try {
            userInfo = this.rsm.constructUser();
            userInfo.setDescription(user.getDescription());
            userInfo.setLogin(user.getName());
            userInfo.setName(user.getName());
            userInfo.setPassword(user.getPassword());
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        return userInfo;
    }

    private IRole createRoleInfo(ProxyPentahoRole role) {
        IRole roleInfo = null;
        try {
            roleInfo = this.rsm.constructRole();
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        roleInfo.setDescription(role.getDescription());
        roleInfo.setName(role.getName());
        return roleInfo;
    }

    private IUser createUserInfo(String user) {
        IUser userInfo = null;
        try {
            userInfo = this.rsm.constructUser();
            userInfo.setName(user);
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        return userInfo;
    }

    private IRole createRoleInfo(String role) {
        IRole roleInfo = null;
        try {
            roleInfo = this.rsm.constructRole();
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        roleInfo.setName(role);
        return roleInfo;
    }
}

