/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IRepositoryFactory {
    public static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";
    public static final IRepositoryFactory DEFAULT = new CachingRepositoryFactory(){
        {
            PentahoSystem.registerObject((Object)this);
        }
    };

    public Repository connect(String var1) throws KettleException;

    public void setRepositoryId(String var1);

    public static class DefaultRepositoryFactory
    implements IRepositoryFactory {
        private String repositoryId = "PentahoEnterpriseRepository";

        @Override
        public void setRepositoryId(String id) {
            this.repositoryId = id;
        }

        @Override
        public Repository connect(String repositoryName) throws KettleException {
            RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
            boolean singleDiServerInstance = "true".equals(PentahoSystem.getSystemSetting((String)IRepositoryFactory.SINGLE_DI_SERVER_INSTANCE, (String)"true"));
            try {
                if (singleDiServerInstance) {
                    String repositoriesXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><repositories><repository><id>" + this.repositoryId + "</id><name>" + IRepositoryFactory.SINGLE_DI_SERVER_INSTANCE + "</name><description>" + IRepositoryFactory.SINGLE_DI_SERVER_INSTANCE + "</description><repository_location_url>" + PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + "</repository_location_url><version_comment_mandatory>N</version_comment_mandatory></repository></repositories>";
                    ByteArrayInputStream sbis = new ByteArrayInputStream(repositoriesXml.getBytes("UTF8"));
                    repositoriesMeta.readDataFromInputStream((InputStream)sbis);
                } else {
                    repositoriesMeta.readData();
                }
            }
            catch (Exception e) {
                throw new KettleException("Meta repository not populated", (Throwable)e);
            }
            RepositoryMeta repositoryMeta = null;
            try {
                repositoryMeta = singleDiServerInstance ? repositoriesMeta.findRepository(IRepositoryFactory.SINGLE_DI_SERVER_INSTANCE) : repositoriesMeta.findRepository(repositoryName);
            }
            catch (Exception e) {
                throw new KettleException("Repository not found", (Throwable)e);
            }
            if (repositoryMeta == null) {
                throw new KettleException("RepositoryMeta is null");
            }
            Repository repository = null;
            try {
                repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
                repository.init(repositoryMeta);
            }
            catch (Exception e) {
                throw new KettleException("Could not get repository instance", (Throwable)e);
            }
            repository.connect(PentahoSessionHolder.getSession().getName(), "password");
            return repository;
        }
    }

    public static class CachingRepositoryFactory
    implements IRepositoryFactory {
        public static final String REGION = "pdi-repository-cache";
        private IRepositoryFactory delegate;
        private Logger logger = LoggerFactory.getLogger(this.getClass());

        public CachingRepositoryFactory() {
            this(new DefaultRepositoryFactory());
        }

        public CachingRepositoryFactory(IRepositoryFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setRepositoryId(String id) {
            this.delegate.setRepositoryId(id);
        }

        @Override
        public Repository connect(String repositoryName) throws KettleException {
            String sessionName;
            IPentahoSession session = PentahoSessionHolder.getSession();
            if (session == null) {
                this.logger.debug("No active Pentaho Session, attempting to load PDI repository unauthenticated.");
                throw new KettleException("Attempting to create PDI Repository with no Active PentahoSession. This is not allowed.");
            }
            ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)session);
            Repository repository = (Repository)cacheManager.getFromRegionCache(REGION, (Object)(sessionName = session.getName()));
            if (repository == null) {
                this.logger.debug("Repository not cached for user: " + sessionName + ". Creating new Repository.");
                repository = this.delegate.connect(repositoryName);
                if (!cacheManager.cacheEnabled(REGION)) {
                    cacheManager.addCacheRegion(REGION);
                }
                cacheManager.putInRegionCache(REGION, (Object)sessionName, (Object)repository);
            } else {
                this.logger.debug("Repository was cached for user: " + sessionName);
            }
            return repository;
        }
    }
}

