/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.ui.xul.components.XulCheckbox;

public class PermissionsCheckboxHandler {
    private final List<PermissionsCheckboxes> ALL_PERMISSIONS;

    public PermissionsCheckboxHandler(XulCheckbox readCheckbox, XulCheckbox writeCheckbox, XulCheckbox deleteCheckbox, XulCheckbox manageCheckbox) {
        ArrayList<PermissionsCheckboxes> permissionsList = new ArrayList<PermissionsCheckboxes>();
        permissionsList.add(new PermissionsCheckboxes(RepositoryFilePermission.ACL_MANAGEMENT, manageCheckbox, Arrays.asList(manageCheckbox), Arrays.asList(readCheckbox, writeCheckbox, deleteCheckbox)));
        permissionsList.add(new PermissionsCheckboxes(RepositoryFilePermission.DELETE, deleteCheckbox, Arrays.asList(manageCheckbox, deleteCheckbox), Arrays.asList(readCheckbox, writeCheckbox)));
        permissionsList.add(new PermissionsCheckboxes(RepositoryFilePermission.WRITE, writeCheckbox, Arrays.asList(writeCheckbox, deleteCheckbox), Arrays.asList(readCheckbox, manageCheckbox)));
        permissionsList.add(new PermissionsCheckboxes(RepositoryFilePermission.READ, readCheckbox, Arrays.asList(writeCheckbox), Arrays.asList(readCheckbox, deleteCheckbox, manageCheckbox)));
        this.ALL_PERMISSIONS = Collections.unmodifiableList(permissionsList);
    }

    private void enableDisableBoxes(boolean enableAppropriate, PermissionsCheckboxes permissionsCheckboxes) {
        for (XulCheckbox checkbox : permissionsCheckboxes.disabledBoxes) {
            checkbox.setDisabled(true);
        }
        for (XulCheckbox checkbox : permissionsCheckboxes.enabledBoxes) {
            checkbox.setDisabled(!enableAppropriate);
        }
    }

    public EnumSet<RepositoryFilePermission> processCheckboxes() {
        return this.processCheckboxes(false);
    }

    public EnumSet<RepositoryFilePermission> processCheckboxes(boolean enableAppropriate) {
        EnumSet<RepositoryFilePermission> result = EnumSet.noneOf(RepositoryFilePermission.class);
        boolean foundMaxPermission = false;
        for (PermissionsCheckboxes permissionsCheckboxes : this.ALL_PERMISSIONS) {
            if (foundMaxPermission) {
                result.add(permissionsCheckboxes.repositoryFilePermission);
                continue;
            }
            if (!permissionsCheckboxes.permissionCheckbox.isChecked()) continue;
            this.enableDisableBoxes(enableAppropriate, permissionsCheckboxes);
            foundMaxPermission = true;
            result.add(permissionsCheckboxes.repositoryFilePermission);
        }
        if (!foundMaxPermission) {
            this.setAllDisabled(true);
            if (enableAppropriate) {
                this.ALL_PERMISSIONS.get((int)(this.ALL_PERMISSIONS.size() - 1)).permissionCheckbox.setDisabled(false);
            }
        }
        return result;
    }

    public void updateCheckboxes(EnumSet<RepositoryFilePermission> permissionEnumSet) {
        this.updateCheckboxes(false, permissionEnumSet);
    }

    public void updateCheckboxes(boolean enableAppropriate, EnumSet<RepositoryFilePermission> permissionEnumSet) {
        HashSet<RepositoryFilePermission> permissions = new HashSet<RepositoryFilePermission>(Arrays.asList(permissionEnumSet.toArray(new RepositoryFilePermission[permissionEnumSet.size()])));
        boolean foundMaxPermission = false;
        if (permissions.remove(RepositoryFilePermission.ALL)) {
            permissions.add(this.ALL_PERMISSIONS.get((int)0).repositoryFilePermission);
        }
        for (PermissionsCheckboxes permissionsCheckboxes : this.ALL_PERMISSIONS) {
            if (foundMaxPermission) {
                permissionsCheckboxes.permissionCheckbox.setChecked(true);
                continue;
            }
            if (permissions.contains(permissionsCheckboxes.repositoryFilePermission)) {
                foundMaxPermission = true;
                permissionsCheckboxes.permissionCheckbox.setChecked(true);
                this.enableDisableBoxes(enableAppropriate, permissionsCheckboxes);
                continue;
            }
            permissionsCheckboxes.permissionCheckbox.setChecked(false);
        }
        if (!foundMaxPermission) {
            this.setAllDisabled(true);
            if (enableAppropriate) {
                this.ALL_PERMISSIONS.get((int)(this.ALL_PERMISSIONS.size() - 1)).permissionCheckbox.setDisabled(false);
            }
        }
    }

    public void setAllChecked(boolean value) {
        for (PermissionsCheckboxes permissionsCheckboxes : this.ALL_PERMISSIONS) {
            permissionsCheckboxes.permissionCheckbox.setChecked(value);
        }
    }

    public void setAllDisabled(boolean value) {
        for (PermissionsCheckboxes permissionsCheckboxes : this.ALL_PERMISSIONS) {
            permissionsCheckboxes.permissionCheckbox.setDisabled(value);
        }
    }

    private static class PermissionsCheckboxes {
        public final RepositoryFilePermission repositoryFilePermission;
        public final XulCheckbox permissionCheckbox;
        public final Set<XulCheckbox> enabledBoxes;
        public final Set<XulCheckbox> disabledBoxes;

        public PermissionsCheckboxes(RepositoryFilePermission repositoryFilePermission, XulCheckbox permissionCheckbox, Collection<XulCheckbox> enabledBoxes, Collection<XulCheckbox> disabledBoxes) {
            this.repositoryFilePermission = repositoryFilePermission;
            this.permissionCheckbox = permissionCheckbox;
            this.enabledBoxes = Collections.unmodifiableSet(new HashSet<XulCheckbox>(enabledBoxes));
            this.disabledBoxes = Collections.unmodifiableSet(new HashSet<XulCheckbox>(disabledBoxes));
        }
    }
}

