/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.io.Serializable;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.delegates.SpoonJobDelegate;
import org.pentaho.xul.swt.tab.TabItem;

public class SpoonEEJobDelegate
extends SpoonJobDelegate
implements Serializable {
    private static final long serialVersionUID = 5658845199854709546L;
    ILockService service;

    public SpoonEEJobDelegate(Spoon spoon) {
        super(spoon);
        Repository repository = spoon.getRepository();
        try {
            if (!repository.hasService(ILockService.class)) {
                throw new IllegalStateException();
            }
            this.service = (ILockService)repository.getService(ILockService.class);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    public void addJobGraph(JobMeta jobMeta) {
        super.addJobGraph(jobMeta);
        TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry((Object)jobMeta);
        if (tabEntry != null) {
            TabItem tabItem = tabEntry.getTabItem();
            try {
                if (this.service != null && jobMeta.getObjectId() != null && this.service.getJobLock(jobMeta.getObjectId()) != null) {
                    tabItem.setImage(GUIResource.getInstance().getImageLocked());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

