/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.dimoutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.palo.core.PaloDimensionLevel;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutput;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="PaloDimOutput", image="PaloDimOutput.svg", i18nPackageName="org.pentaho.di.trans.steps.palo.dimoutput", name="PaloDimOutput.TransName", description="PaloDimOutput.TransDescription", documentationUrl="http://wiki.pentaho.com/display/EAI/Palo+Dimension+Output", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Palo")
public class PaloDimOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String dimension = "";
    private String elementType = "";
    private boolean createNewDimension;
    private boolean clearConsolidations;
    private boolean clearDimension;
    private boolean recreateDimension;
    private boolean enableElementCache = true;
    private boolean preloadElementCache = true;
    private List<PaloDimensionLevel> levels = new ArrayList<PaloDimensionLevel>();

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public final void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public final void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public final Object clone() {
        PaloDimOutputMeta retval = (PaloDimOutputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.dimension = XMLHandler.getTagValue((Node)stepnode, (String)"dimension");
            this.elementType = XMLHandler.getTagValue((Node)stepnode, (String)"elementtype");
            this.createNewDimension = XMLHandler.getTagValue((Node)stepnode, (String)"createdimension").equals("Y");
            boolean bl = this.clearDimension = XMLHandler.getTagValue((Node)stepnode, (String)"cleardimension").equals("Y");
            boolean bl2 = XMLHandler.getTagValue((Node)stepnode, (String)"clearconsolidations") == null ? false : (this.clearConsolidations = XMLHandler.getTagValue((Node)stepnode, (String)"clearconsolidations").equals("Y"));
            boolean bl3 = XMLHandler.getTagValue((Node)stepnode, (String)"recreatedimension") == null ? false : (this.recreateDimension = XMLHandler.getTagValue((Node)stepnode, (String)"recreatedimension").equals("Y"));
            boolean bl4 = XMLHandler.getTagValue((Node)stepnode, (String)"enableElementCache") == null ? false : (this.enableElementCache = XMLHandler.getTagValue((Node)stepnode, (String)"enableElementCache").equals("Y"));
            this.preloadElementCache = XMLHandler.getTagValue((Node)stepnode, (String)"preloadElementCache") == null ? false : XMLHandler.getTagValue((Node)stepnode, (String)"preloadElementCache").equals("Y");
            Node levels = XMLHandler.getSubNode((Node)stepnode, (String)"levels");
            int nrLevels = XMLHandler.countNodes((Node)levels, (String)"level");
            for (int i = 0; i < nrLevels; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)levels, (String)"level", (int)i);
                String levelName = XMLHandler.getTagValue((Node)fnode, (String)"levelname");
                String levelNumber = XMLHandler.getTagValue((Node)fnode, (String)"levelnumber");
                String fieldName = XMLHandler.getTagValue((Node)fnode, (String)"fieldname");
                String fieldType = XMLHandler.getTagValue((Node)fnode, (String)"fieldtype");
                String consolidationField = XMLHandler.getTagValue((Node)fnode, (String)"consolidationfieldname");
                this.levels.add(new PaloDimensionLevel(levelName, Integer.parseInt(levelNumber), fieldName, fieldType, consolidationField));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
    }

    public final String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dimension", (String)this.dimension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"elementtype", (String)this.elementType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"createdimension", (boolean)this.createNewDimension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cleardimension", (boolean)this.clearDimension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"clearconsolidations", (boolean)this.clearConsolidations));
        retval.append("    ").append(XMLHandler.addTagValue((String)"recreatedimension", (boolean)this.recreateDimension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enableElementCache", (boolean)this.enableElementCache));
        retval.append("    ").append(XMLHandler.addTagValue((String)"preloadElementCache", (boolean)this.preloadElementCache));
        retval.append("    <levels>").append(Const.CR);
        for (PaloDimensionLevel level : this.levels) {
            retval.append("      <level>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"levelname", (String)level.getLevelName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"levelnumber", (int)level.getLevelNumber()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldname", (String)level.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"consolidationfieldname", (String)level.getConsolidationFieldName()));
            retval.append("      </level>").append(Const.CR);
        }
        retval.append("    </levels>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(idStep, "connection", databases);
            this.dimension = rep.getStepAttributeString(idStep, "dimension");
            this.elementType = rep.getStepAttributeString(idStep, "elementtype");
            this.createNewDimension = rep.getStepAttributeBoolean(idStep, "createdimension");
            this.clearDimension = rep.getStepAttributeBoolean(idStep, "cleardimension");
            this.clearConsolidations = rep.getStepAttributeBoolean(idStep, "clearconsolidations");
            this.recreateDimension = rep.getStepAttributeBoolean(idStep, "recreatedimension");
            this.enableElementCache = rep.getStepAttributeBoolean(idStep, "enableElementCache");
            this.preloadElementCache = rep.getStepAttributeBoolean(idStep, "preloadElementCache");
            int nrLevels = rep.countNrStepAttributes(idStep, "levelname");
            for (int i = 0; i < nrLevels; ++i) {
                String levelName = rep.getStepAttributeString(idStep, i, "levelname");
                int levelNumber = (int)rep.getStepAttributeInteger(idStep, i, "levelnumber");
                String fieldName = rep.getStepAttributeString(idStep, i, "fieldname");
                String fieldType = rep.getStepAttributeString(idStep, i, "fieldtype");
                String consolidationField = rep.getStepAttributeString(idStep, i, "consolidationfieldname");
                this.levels.add(new PaloDimensionLevel(levelName, levelNumber, fieldName, fieldType, consolidationField));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(idTransformation, idStep, "connection", this.databaseMeta);
            rep.saveStepAttribute(idTransformation, idStep, "dimension", this.dimension);
            rep.saveStepAttribute(idTransformation, idStep, "elementtype", this.elementType);
            rep.saveStepAttribute(idTransformation, idStep, "createdimension", this.createNewDimension);
            rep.saveStepAttribute(idTransformation, idStep, "cleardimension", this.clearDimension);
            rep.saveStepAttribute(idTransformation, idStep, "clearconsolidations", this.clearConsolidations);
            rep.saveStepAttribute(idTransformation, idStep, "recreatedimension", this.recreateDimension);
            rep.saveStepAttribute(idTransformation, idStep, "enableElementCache", this.enableElementCache);
            rep.saveStepAttribute(idTransformation, idStep, "preloadElementCache", this.preloadElementCache);
            for (int i = 0; i < this.levels.size(); ++i) {
                rep.saveStepAttribute(idTransformation, idStep, i, "levelname", this.levels.get(i).getLevelName());
                rep.saveStepAttribute(idTransformation, idStep, i, "levelnumber", (long)this.levels.get(i).getLevelNumber());
                rep.saveStepAttribute(idTransformation, idStep, i, "fieldname", this.levels.get(i).getFieldName());
                rep.saveStepAttribute(idTransformation, idStep, i, "fieldtype", this.levels.get(i).getFieldType());
                rep.saveStepAttribute(idTransformation, idStep, i, "consolidationfieldname", this.levels.get(i).getConsolidationFieldName());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for idStep=" + idStep, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.databaseMeta != null) {
            CheckResult cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            PaloHelper helper = new PaloHelper(this.databaseMeta, DefaultLogLevel.getLogLevel());
            try {
                helper.connect();
                cr = new CheckResult(1, "Connection to database OK", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (!Utils.isEmpty((CharSequence)this.dimension)) {
                    cr = new CheckResult(1, "The name of the dimension is entered", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, "The name of the dimension is missing.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (this.levels == null || this.levels.size() == 0) {
                    cr = new CheckResult(4, "Dimension Output Fields are empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                for (PaloDimensionLevel level : this.levels) {
                    if (Utils.isEmpty((CharSequence)level.getLevelName())) {
                        cr = new CheckResult(4, "Level Name for Level " + level.getLevelNumber() + " is empty.", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    if (Utils.isEmpty((CharSequence)level.getFieldName())) {
                        cr = new CheckResult(4, "Input Field Name for Level " + level.getLevelNumber() + " is empty.", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    if (!Utils.isEmpty((CharSequence)level.getFieldType())) continue;
                    cr = new CheckResult(4, "Level Type for Level " + level.getLevelNumber() + " is empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (KettleException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                helper.disconnect();
            }
        } else {
            CheckResult cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public final StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PaloDimOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public final StepDataInterface getStepData() {
        try {
            return new PaloDimOutputData(this.databaseMeta);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public final String getDimension() {
        return this.dimension;
    }

    public final void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public final String getElementType() {
        return this.elementType;
    }

    public final void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public List<PaloDimensionLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(List<PaloDimensionLevel> levels) {
        this.levels = levels;
    }

    public void setCreateNewDimension(boolean create) {
        this.createNewDimension = create;
    }

    public boolean getCreateNewDimension() {
        return this.createNewDimension;
    }

    public void setClearDimension(boolean create) {
        this.clearDimension = create;
    }

    public boolean getClearDimension() {
        return this.clearDimension;
    }

    public void setClearConsolidations(boolean clear) {
        this.clearConsolidations = clear;
    }

    public boolean getClearConsolidations() {
        return this.clearConsolidations;
    }

    public void setRecreateDimension(boolean recreateDimension) {
        this.recreateDimension = recreateDimension;
    }

    public boolean getRecreateDimension() {
        return this.recreateDimension;
    }

    public void setEnableElementCache(boolean enableElementCache) {
        this.enableElementCache = enableElementCache;
    }

    public boolean getEnableElementCache() {
        return this.enableElementCache;
    }

    public void setPreloadElementCache(boolean preloadElementCache) {
        this.preloadElementCache = preloadElementCache;
    }

    public boolean getPreloadElementCache() {
        return this.preloadElementCache;
    }
}

