/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.synchronize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class CommandLineCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider mCredentialProvider = new BasicCredentialsProvider();

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.mCredentialProvider.setCredentials(authscope, credentials);
    }

    public void clear() {
        this.mCredentialProvider.clear();
    }

    public Credentials getCredentials(AuthScope scope) {
        if (scope == null || scope.getScheme() == null) {
            return null;
        }
        Credentials credentials = this.mCredentialProvider.getCredentials(scope);
        if (credentials != null) {
            return credentials;
        }
        try {
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
            if (scope.getScheme().equals("ntlm")) {
                System.out.println("Proxy Authentication Required -- Host " + scope.getHost() + ":" + scope.getPort() + " requires Windows authentication");
                System.out.print("Username: ");
                String username = inputReader.readLine();
                System.out.print("Password: ");
                String password = inputReader.readLine();
                System.out.print("Domain: ");
                String domain = inputReader.readLine();
                credentials = new NTCredentials(username, password, scope.getHost(), domain);
            } else if (scope.getScheme().equals("basic") || scope.getScheme().equals("digest")) {
                System.out.println("Proxy Authentication Required -- Host " + scope.getHost() + ":" + scope.getPort() + " requires authentication for the realm: " + scope.getRealm());
                System.out.print("Username: ");
                String username = inputReader.readLine();
                System.out.print("Password: ");
                String password = inputReader.readLine();
                credentials = new UsernamePasswordCredentials(username, password);
            } else {
                throw new IllegalArgumentException("Unsupported authentication scheme: " + scope.getScheme());
            }
            if (credentials != null) {
                this.mCredentialProvider.setCredentials(scope, credentials);
            }
            return credentials;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

