/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.Map;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowInstance;
import org.json.simple.JSONValue;

public class HadoopELFunctions {
    private static final String HADOOP_COUNTERS = "oozie.el.action.hadoop.counters";
    public static final String RECORDS = "org.apache.hadoop.mapred.Task$Counter";
    public static final String MAP_IN = "MAP_INPUT_RECORDS";
    public static final String MAP_OUT = "MAP_OUTPUT_RECORDS";
    public static final String REDUCE_IN = "REDUCE_INPUT_RECORDS";
    public static final String REDUCE_OUT = "REDUCE_OUTPUT_RECORDS";
    public static final String GROUPS = "REDUCE_INPUT_GROUPS";

    public static Map<String, Map<String, Long>> hadoop_counters(String nodeName) throws ELEvaluationException {
        WorkflowInstance instance = DagELFunctions.getWorkflow().getWorkflowInstance();
        Object obj = instance.getTransientVar(nodeName + "#" + HADOOP_COUNTERS);
        Map<String, Map<String, Long>> counters = (Map<String, Map<String, Long>>)obj;
        if (counters == null) {
            counters = HadoopELFunctions.getCounters(nodeName);
            instance.setTransientVar(nodeName + "#" + HADOOP_COUNTERS, counters);
        }
        return counters;
    }

    private static Map<String, Map<String, Long>> getCounters(String nodeName) throws ELEvaluationException {
        String jsonCounters = DagELFunctions.getActionVar(nodeName, "hadoop.counters");
        if (jsonCounters == null) {
            throw new IllegalArgumentException(XLog.format("Hadoop counters not available for action [{0}]", nodeName));
        }
        return (Map)JSONValue.parse((String)jsonCounters);
    }
}

