/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.List;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class SuspendCommand
extends WorkflowCommand<Void> {
    private String id;

    public SuspendCommand(String id) {
        super("suspend", "suspend", 1, 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        try {
            WorkflowJobBean workflow = store.getWorkflow(this.id, false);
            this.setLogInfo(workflow);
            if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
                this.incrJobCounter(1);
                SuspendCommand.suspendJob(store, workflow, this.id, null);
                store.updateWorkflow(workflow);
                this.queueCallable(new NotificationCommand(workflow));
            }
            return null;
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
    }

    public static void suspendJob(WorkflowStore store, WorkflowJobBean workflow, String id, String actionId) throws WorkflowException, StoreException {
        if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
            workflow.getWorkflowInstance().suspend();
            WorkflowInstance wfInstance = workflow.getWorkflowInstance();
            ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.SUSPENDED);
            workflow.setStatus(WorkflowJob.Status.SUSPENDED);
            workflow.setWorkflowInstance(wfInstance);
            SuspendCommand.setPendingFalseForActions(store, id, actionId);
        }
    }

    public static void setPendingFalseForActions(WorkflowStore store, String id, String actionId) throws StoreException {
        List<WorkflowActionBean> actions = store.getRetryAndManualActions(id);
        for (WorkflowActionBean action : actions) {
            if (actionId != null && actionId.equals(action.getId())) continue;
            action.resetPendingOnly();
            store.updateAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        XLog.getLog(this.getClass()).debug("STARTED SuspendCommand for wf id=" + this.id);
        try {
            if (this.lock(this.id)) {
                this.call(store);
            } else {
                this.queueCallable(new SuspendCommand(this.id), 30000L);
                XLog.getLog(this.getClass()).warn("Suspend lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new SuspendCommand(this.id), 30000L);
            XLog.getLog(this.getClass()).warn("SuspendCommand lock was not acquired - interrupted exception failed {0}", this.id);
        }
        finally {
            XLog.getLog(this.getClass()).debug("ENDED SuspendCommand for wf id=" + this.id);
        }
        return null;
    }
}

