/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleJobGetCoordinatorsJPAExecutor
implements JPAExecutor<List<CoordinatorJobBean>> {
    private String bundleId = null;

    public BundleJobGetCoordinatorsJPAExecutor(String bundleId) {
        ParamChecker.notNull(bundleId, "bundleId");
        this.bundleId = bundleId;
    }

    @Override
    public String getName() {
        return "BundleJobGetCoordinatorsJPAExecutor";
    }

    @Override
    public List<CoordinatorJobBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_JOBS_FOR_BUNDLE");
            q.setParameter("bundleId", (Object)this.bundleId);
            List coordJobBeans = q.getResultList();
            for (CoordinatorJobBean cjBean : coordJobBeans) {
                cjBean.setStatus(cjBean.getStatus());
                cjBean.setTimeUnit(cjBean.getTimeUnit());
                cjBean.setStartTimestamp(cjBean.getStartTimestamp());
                cjBean.setEndTimestamp(cjBean.getEndTimestamp());
                cjBean.setNextMaterializedTimestamp(cjBean.getNextMaterializedTimestamp());
            }
            return coordJobBeans;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
    }
}

