/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.util.BuiltInMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableTableScan
extends TableScan
implements EnumerableRel {
    private final Class elementType;

    public EnumerableTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Class elementType) {
        super(cluster, traitSet, table);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.elementType = elementType;
    }

    private Expression getExpression(PhysType physType) {
        Expression expression = this.table.getExpression(Queryable.class);
        Expression expression2 = this.toEnumerable(expression);
        assert (Types.isAssignableFrom(Enumerable.class, (Type)expression2.getType()));
        Expression expression3 = this.toRows(physType, expression2);
        return expression3;
    }

    private Expression toEnumerable(Expression expression) {
        Type type = expression.getType();
        if (Types.isArray((Type)type)) {
            if (Types.toClass((Type)type).getComponentType().isPrimitive()) {
                expression = Expressions.call((Method)BuiltInMethod.AS_LIST.method, (Expression[])new Expression[]{expression});
            }
            return Expressions.call((Method)BuiltInMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{expression});
        }
        if (Types.isAssignableFrom(Iterable.class, (Type)type) && !Types.isAssignableFrom(Enumerable.class, (Type)type)) {
            return Expressions.call((Method)BuiltInMethod.AS_ENUMERABLE2.method, (Expression[])new Expression[]{expression});
        }
        if (Types.isAssignableFrom(Queryable.class, (Type)type)) {
            return Expressions.call((Expression)expression, (Method)BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
        }
        return expression;
    }

    private Expression toRows(PhysType physType, Expression expression) {
        if (physType.getFormat() == JavaRowFormat.SCALAR && Object[].class.isAssignableFrom(this.elementType) && this.getRowType().getFieldCount() == 1 && (this.table.unwrap(ScannableTable.class) != null || this.table.unwrap(FilterableTable.class) != null || this.table.unwrap(ProjectableFilterableTable.class) != null)) {
            return Expressions.call((Method)BuiltInMethod.SLICE0.method, (Expression[])new Expression[]{expression});
        }
        JavaRowFormat oldFormat = this.format();
        if (physType.getFormat() == oldFormat) {
            return expression;
        }
        ParameterExpression row_ = Expressions.parameter((Type)this.elementType, (String)"row");
        int fieldCount = this.table.getRowType().getFieldCount();
        ArrayList<Expression> expressionList = new ArrayList<Expression>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            expressionList.add(oldFormat.field((Expression)row_, i, physType.getJavaFieldType(i)));
        }
        return Expressions.call((Expression)expression, (Method)BuiltInMethod.SELECT.method, (Expression[])new Expression[]{Expressions.lambda(Function1.class, (Expression)physType.record(expressionList), (ParameterExpression[])new ParameterExpression[]{row_})});
    }

    private JavaRowFormat format() {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldCount == 0) {
            return JavaRowFormat.LIST;
        }
        if (Object[].class.isAssignableFrom(this.elementType)) {
            return fieldCount == 1 ? JavaRowFormat.SCALAR : JavaRowFormat.ARRAY;
        }
        if (Row.class.isAssignableFrom(this.elementType)) {
            return JavaRowFormat.ROW;
        }
        if (fieldCount == 1 && (Object.class == this.elementType || Primitive.is((Type)this.elementType) || Number.class.isAssignableFrom(this.elementType))) {
            return JavaRowFormat.SCALAR;
        }
        return JavaRowFormat.CUSTOM;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableScan(this.getCluster(), traitSet, this.table, this.elementType);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.format());
        Expression expression = this.getExpression(physType);
        return implementor.result(physType, Blocks.toBlock((Node)expression));
    }
}

