/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexToLixTranslator {
    public static final Map<Method, SqlOperator> JAVA_TO_SQL_METHOD_MAP = Util.mapOf(RexToLixTranslator.findMethod(String.class, "toUpperCase", new Class[0]), SqlStdOperatorTable.UPPER, RexToLixTranslator.findMethod(SqlFunctions.class, "substring", String.class, Integer.TYPE, Integer.TYPE), SqlStdOperatorTable.SUBSTRING, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHARACTER_LENGTH, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHAR_LENGTH);
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    private final RexProgram program;
    private final Expression root;
    private final InputGetter inputGetter;
    private final BlockBuilder list;
    private final Map<? extends RexNode, Boolean> exprNullableMap;
    private final RexToLixTranslator parent;
    private final Function1<String, InputGetter> correlates;

    private static Method findMethod(Class<?> clazz, String name, Class ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, Expression root, InputGetter inputGetter, BlockBuilder list) {
        this(program, typeFactory, root, inputGetter, list, Collections.emptyMap(), new RexBuilder(typeFactory));
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, Expression root, InputGetter inputGetter, BlockBuilder list, Map<RexNode, Boolean> exprNullableMap, RexBuilder builder) {
        this(program, typeFactory, root, inputGetter, list, exprNullableMap, builder, null);
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, Expression root, InputGetter inputGetter, BlockBuilder list, Map<? extends RexNode, Boolean> exprNullableMap, RexBuilder builder, RexToLixTranslator parent) {
        this(program, typeFactory, root, inputGetter, list, exprNullableMap, builder, parent, null);
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, Expression root, InputGetter inputGetter, BlockBuilder list, Map<? extends RexNode, Boolean> exprNullableMap, RexBuilder builder, RexToLixTranslator parent, Function1<String, InputGetter> correlates) {
        this.program = program;
        this.typeFactory = typeFactory;
        this.root = root;
        this.inputGetter = inputGetter;
        this.list = list;
        this.exprNullableMap = exprNullableMap;
        this.builder = builder;
        this.parent = parent;
        this.correlates = correlates;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, PhysType outputPhysType, Expression root, InputGetter inputGetter, Function1<String, InputGetter> correlates) {
        ArrayList<Type> storageTypes = null;
        if (outputPhysType != null) {
            RelDataType rowType = outputPhysType.getRowType();
            storageTypes = new ArrayList<Type>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                storageTypes.add(outputPhysType.getJavaFieldType(i));
            }
        }
        return new RexToLixTranslator(program, typeFactory, root, inputGetter, list).setCorrelates(correlates).translateList(program.getProjectList(), storageTypes);
    }

    public static RexToLixTranslator forAggregation(JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter) {
        ParameterExpression root = DataContext.ROOT;
        return new RexToLixTranslator(null, typeFactory, (Expression)root, inputGetter, list);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        return this.translate(expr, nullAs, null);
    }

    Expression translate(RexNode expr, Type storageType) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs, storageType);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        Expression expression = this.translate0(expr, nullAs, storageType);
        assert (expression != null);
        return this.list.append("v", expression);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand) {
        Expression convert = null;
        block0 : switch (targetType.getSqlTypeName()) {
            case ANY: {
                convert = operand;
                break;
            }
            case DATE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_DATE.method, (Expression[])new Expression[]{operand});
                    }
                }
                break;
            }
            case TIME: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_TIME.method, (Expression[])new Expression[]{operand});
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand});
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_BOOLEAN.method, (Expression[])new Expression[]{operand});
                    }
                }
                break;
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break block0;
                    }
                    case TIME: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIME_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)interval.timeUnitRange)}));
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)interval.timeUnitRange), Expressions.constant((Object)interval.getFractionalSecondPrecision(this.typeFactory.getTypeSystem()))}));
                        break block0;
                    }
                    case BOOLEAN: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.BOOLEAN_TO_STRING.method, (Expression[])new Expression[]{operand}));
                    }
                }
            }
        }
        if (convert == null) {
            convert = RexToLixTranslator.convert(operand, this.typeFactory.getJavaClass(targetType));
        }
        switch (sourceType.getSqlTypeName()) {
            case CHAR: {
                switch (targetType.getSqlTypeName()) {
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.RTRIM.method, (Expression[])new Expression[]{convert});
                    }
                }
                break;
            }
            case BINARY: {
                switch (targetType.getSqlTypeName()) {
                    case VARBINARY: {
                        convert = Expressions.call((Method)BuiltInMethod.RTRIM.method, (Expression[])new Expression[]{convert});
                    }
                }
            }
        }
        switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: 
            case VARBINARY: 
            case BINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) break;
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case VARBINARY: 
                    case BINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (sourcePrecision < 0 || sourcePrecision >= 0 && sourcePrecision <= targetPrecision) break;
                    }
                    default: {
                        convert = Expressions.call((Method)BuiltInMethod.TRUNCATE.method, (Expression[])new Expression[]{convert, Expressions.constant((Object)targetPrecision)});
                        break;
                    }
                }
                break;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale >= sourceType.getScale()) break;
                convert = Expressions.call((Method)BuiltInMethod.ROUND_LONG.method, (Expression[])new Expression[]{convert, Expressions.constant((Object)((long)Math.pow(10.0, 3 - targetScale)))});
            }
        }
        return convert;
    }

    private Expression translate0(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        if (nullAs == RexImpTable.NullAs.NULL && !expr.getType().isNullable()) {
            nullAs = RexImpTable.NullAs.NOT_POSSIBLE;
        }
        switch (expr.getKind()) {
            case INPUT_REF: {
                int index = ((RexInputRef)expr).getIndex();
                Expression x = this.inputGetter.field(this.list, index, storageType);
                Expression input = this.list.append("inp" + index + "_", x);
                if (nullAs == RexImpTable.NullAs.NOT_POSSIBLE && input.type.equals(storageType)) {
                    return input;
                }
                Expression nullHandled = nullAs.handle(input);
                if (nullHandled instanceof ConstantExpression) {
                    return nullHandled;
                }
                if (nullHandled == input) {
                    return input;
                }
                String unboxVarName = "v_unboxed";
                if (input instanceof ParameterExpression) {
                    unboxVarName = ((ParameterExpression)input).name + "_unboxed";
                }
                ParameterExpression unboxed = Expressions.parameter((Type)nullHandled.getType(), (String)this.list.newName(unboxVarName));
                this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)unboxed, (Expression)nullHandled));
                return unboxed;
            }
            case LOCAL_REF: {
                return this.translate(this.deref(expr), nullAs, storageType);
            }
            case LITERAL: {
                return RexToLixTranslator.translateLiteral((RexLiteral)expr, this.nullifyType(expr.getType(), this.isNullable(expr) && nullAs != RexImpTable.NullAs.NOT_POSSIBLE), this.typeFactory, nullAs);
            }
            case DYNAMIC_PARAM: {
                return this.translateParameter((RexDynamicParam)expr, nullAs, storageType);
            }
            case CORREL_VARIABLE: {
                throw new RuntimeException("Cannot translate " + expr + ". Correlated" + " variables should always be referenced by field access");
            }
            case FIELD_ACCESS: {
                RexFieldAccess fieldAccess = (RexFieldAccess)expr;
                RexNode target = this.deref(fieldAccess.getReferenceExpr());
                if (!(target instanceof RexCorrelVariable)) {
                    throw new RuntimeException("cannot translate expression " + expr);
                }
                if (this.correlates == null) {
                    throw new RuntimeException("Cannot translate " + expr + " since " + "correlate variables resolver is not defined");
                }
                InputGetter getter = (InputGetter)this.correlates.apply((Object)((RexCorrelVariable)target).getName());
                Expression res = getter.field(this.list, fieldAccess.getField().getIndex(), storageType);
                return res;
            }
        }
        if (expr instanceof RexCall) {
            return this.translateCall((RexCall)expr, nullAs);
        }
        throw new RuntimeException("cannot translate expression " + expr);
    }

    public RexNode deref(RexNode expr) {
        if (expr instanceof RexLocalRef) {
            RexLocalRef ref = (RexLocalRef)expr;
            RexNode e2 = this.program.getExprList().get(ref.getIndex());
            assert (ref.getType().equals(e2.getType()));
            return e2;
        }
        return expr;
    }

    private Expression translateCall(RexCall call, RexImpTable.NullAs nullAs) {
        SqlOperator operator = call.getOperator();
        CallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        return implementor.implement(this, call, nullAs);
    }

    private Expression translateParameter(RexDynamicParam expr, RexImpTable.NullAs nullAs, Type storageType) {
        if (storageType == null) {
            storageType = this.typeFactory.getJavaClass(expr.getType());
        }
        return nullAs.handle(RexToLixTranslator.convert((Expression)Expressions.call((Expression)this.root, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)("?" + expr.getIndex()))}), storageType));
    }

    public static Expression translateLiteral(RexLiteral literal, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        Comparable value = literal.getValue();
        if (value == null) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw AlwaysNull.INSTANCE;
                }
            }
            return RexImpTable.NULL_EXPR;
        }
        switch (nullAs) {
            case IS_NOT_NULL: {
                return RexImpTable.TRUE_EXPR;
            }
            case IS_NULL: {
                return RexImpTable.FALSE_EXPR;
            }
        }
        Class<Object> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                assert (javaClass == BigDecimal.class);
                return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.constant((Object)value.toString())});
            }
            case DATE: {
                value2 = (int)(((Calendar)value).getTimeInMillis() / 86400000L);
                javaClass = Integer.TYPE;
                break;
            }
            case TIME: {
                value2 = (int)(((Calendar)value).getTimeInMillis() % 86400000L);
                javaClass = Integer.TYPE;
                break;
            }
            case TIMESTAMP: {
                value2 = ((Calendar)value).getTimeInMillis();
                javaClass = Long.TYPE;
                break;
            }
            case INTERVAL_DAY_TIME: {
                value2 = ((BigDecimal)value).longValue();
                javaClass = Long.TYPE;
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                value2 = ((BigDecimal)value).intValue();
                javaClass = Integer.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = ((NlsString)value).getValue();
                break;
            }
            case VARBINARY: 
            case BINARY: {
                return Expressions.new_(ByteString.class, (Expression[])new Expression[]{Expressions.constant((Object)((ByteString)value).getBytes(), byte[].class)});
            }
            case SYMBOL: {
                value2 = value;
                javaClass = value.getClass();
                break;
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr((Type)javaClass);
                value2 = primitive != null && value instanceof Number ? primitive.number((Number)((Object)value)) : value;
            }
        }
        return Expressions.constant((Object)value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (RexNode rex : operandList) {
            list.add(this.translate(rex, nullAs));
        }
        return list;
    }

    public List<Expression> translateList(List<? extends RexNode> operandList) {
        return this.translateList(operandList, (List<? extends Type>)null);
    }

    public List<Expression> translateList(List<? extends RexNode> operandList, List<? extends Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>(operandList.size());
        for (int i = 0; i < operandList.size(); ++i) {
            RexNode rex = operandList.get(i);
            Type desiredType = null;
            if (storageTypes != null) {
                desiredType = storageTypes.get(i);
            }
            Expression translate = this.translate(rex, desiredType);
            list.add(translate);
            if (desiredType == null && !this.isNullable(rex)) assert (!Primitive.isBox((Type)translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rex + ", " + translate.getType();
        }
        return list;
    }

    public static Expression translateCondition(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter, Function1<String, InputGetter> correlates) {
        if (program.getCondition() == null) {
            return RexImpTable.TRUE_EXPR;
        }
        ParameterExpression root = DataContext.ROOT;
        RexToLixTranslator translator = new RexToLixTranslator(program, typeFactory, (Expression)root, inputGetter, list);
        translator = translator.setCorrelates(correlates);
        return translator.translate((RexNode)program.getCondition(), RexImpTable.NullAs.FALSE);
    }

    public static Expression convert(Expression operand, Type toType) {
        boolean fromNumber;
        Type fromType = operand.getType();
        if (fromType.equals(toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of((Type)toType);
        Primitive toBox = Primitive.ofBox((Type)toType);
        Primitive fromBox = Primitive.ofBox((Type)fromType);
        Primitive fromPrimitive = Primitive.of((Type)fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, (String)("parse" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toBox.primitiveName) + "Boxed"), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, (String)"valueOf", (Expression[])new Expression[]{operand});
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_((Expression)operand, (Type)toPrimitive.primitiveClass);
            }
            if (fromNumber || fromBox == Primitive.CHAR) {
                return Expressions.unbox((Expression)operand, (Primitive)toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.box((Expression)Expressions.unbox((Expression)operand, (Primitive)toBox), (Primitive)toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert || Primitive.of((Type)una.getType()) == toBox) {
                    return Expressions.box((Expression)una.expression, (Primitive)toBox);
                }
            }
            return Expressions.box((Expression)operand, (Primitive)toBox);
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.unbox((Expression)operand, (Primitive)fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{operand});
            }
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{operand}));
        }
        if (toType == String.class) {
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.boxClass, (String)"toString", (Expression[])new Expression[]{operand});
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand}));
            }
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call((Expression)operand, (String)"toString", (Expression[])new Expression[0]));
        }
        return Expressions.convert_((Expression)operand, (Type)toType);
    }

    public Expression translateConstructor(List<RexNode> operandList, SqlKind kind) {
        switch (kind) {
            case MAP_VALUE_CONSTRUCTOR: {
                Expression map = this.list.append("map", (Expression)Expressions.new_(LinkedHashMap.class), false);
                for (int i = 0; i < operandList.size(); ++i) {
                    RexNode key = operandList.get(i++);
                    RexNode value = operandList.get(i);
                    this.list.add(Expressions.statement((Expression)Expressions.call((Expression)map, (Method)BuiltInMethod.MAP_PUT.method, (Expression[])new Expression[]{Expressions.box((Expression)this.translate(key)), Expressions.box((Expression)this.translate(value))})));
                }
                return map;
            }
            case ARRAY_VALUE_CONSTRUCTOR: {
                Expression lyst = this.list.append("list", (Expression)Expressions.new_(ArrayList.class), false);
                for (RexNode value : operandList) {
                    this.list.add(Expressions.statement((Expression)Expressions.call((Expression)lyst, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Expressions.box((Expression)this.translate(value))})));
                }
                return lyst;
            }
        }
        throw new AssertionError((Object)("unexpected: " + (Object)((Object)kind)));
    }

    public boolean isNullable(RexNode e) {
        if (!e.getType().isNullable()) {
            return false;
        }
        Boolean b = this.isKnownNullable(e);
        return b == null || b != false;
    }

    protected Boolean isKnownNullable(RexNode node) {
        Boolean nullable;
        if (!this.exprNullableMap.isEmpty() && (nullable = this.exprNullableMap.get(node)) != null) {
            return nullable;
        }
        return this.parent == null ? null : this.parent.isKnownNullable(node);
    }

    public RexToLixTranslator setNullable(RexNode e, boolean nullable) {
        return this.setNullable(Collections.singletonMap(e, nullable));
    }

    public RexToLixTranslator setNullable(Map<? extends RexNode, Boolean> nullable) {
        if (nullable == null || nullable.isEmpty()) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, nullable, this.builder, this, this.correlates);
    }

    public RexToLixTranslator setBlock(BlockBuilder block) {
        if (block == this.list) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, block, (Map<? extends RexNode, Boolean>)ImmutableMap.of(), this.builder, this, this.correlates);
    }

    public RexToLixTranslator setCorrelates(Function1<String, InputGetter> correlates) {
        if (this.correlates == correlates) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, Collections.emptyMap(), this.builder, this, correlates);
    }

    public RelDataType nullifyType(RelDataType type, boolean nullable) {
        Primitive primitive;
        if (!nullable && (primitive = this.javaPrimitive(type)) != null) {
            return this.typeFactory.createJavaType(primitive.primitiveClass);
        }
        return this.typeFactory.createTypeWithNullability(type, nullable);
    }

    private Primitive javaPrimitive(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return Primitive.ofBox((Type)((RelDataTypeFactoryImpl.JavaType)type).getJavaClass());
        }
        return null;
    }

    public Expression getRoot() {
        return this.root;
    }

    static class AlwaysNull
    extends ControlFlowException {
        public static final AlwaysNull INSTANCE = new AlwaysNull();

        private AlwaysNull() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputGetterImpl
    implements InputGetter {
        private List<Pair<Expression, PhysType>> inputs;

        public InputGetterImpl(List<Pair<Expression, PhysType>> inputs) {
            this.inputs = inputs;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            int offset = 0;
            for (Pair<Expression, PhysType> input : this.inputs) {
                PhysType physType = (PhysType)input.right;
                int fieldCount = physType.getRowType().getFieldCount();
                if (index >= offset + fieldCount) {
                    offset += fieldCount;
                    continue;
                }
                Expression left = list.append("current", (Expression)input.left);
                return physType.fieldReference(left, index - offset, storageType);
            }
            throw new IllegalArgumentException("Unable to find field #" + index);
        }
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2, Type var3);
    }
}

