/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.interpreter.AggregateNode;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.FilterNode;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.JoinNode;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.NoneToBindableConverterRule;
import org.apache.calcite.interpreter.ProjectNode;
import org.apache.calcite.interpreter.SortNode;
import org.apache.calcite.interpreter.UnionNode;
import org.apache.calcite.interpreter.ValuesNode;
import org.apache.calcite.interpreter.WindowNode;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.util.ImmutableBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bindables {
    public static final RelOptRule BINDABLE_TABLE_RULE = new BindableTableScanRule();
    public static final RelOptRule BINDABLE_FILTER_RULE = new BindableFilterRule();
    public static final RelOptRule BINDABLE_PROJECT_RULE = new BindableProjectRule();
    public static final RelOptRule BINDABLE_SORT_RULE = new BindableSortRule();
    public static final RelOptRule BINDABLE_JOIN_RULE = new BindableJoinRule();
    public static final RelOptRule BINDABLE_UNION_RULE = new BindableUnionRule();
    public static final RelOptRule BINDABLE_VALUES_RULE = new BindableValuesRule();
    public static final RelOptRule BINDABLE_AGGREGATE_RULE = new BindableAggregateRule();
    public static final RelOptRule BINDABLE_WINDOW_RULE = new BindableWindowRule();
    public static final ImmutableList<RelOptRule> RULES = ImmutableList.of((Object)NoneToBindableConverterRule.INSTANCE, (Object)BINDABLE_TABLE_RULE, (Object)BINDABLE_FILTER_RULE, (Object)BINDABLE_PROJECT_RULE, (Object)BINDABLE_SORT_RULE, (Object)BINDABLE_JOIN_RULE, (Object)BINDABLE_UNION_RULE, (Object)BINDABLE_VALUES_RULE, (Object)BINDABLE_AGGREGATE_RULE, (Object)BINDABLE_WINDOW_RULE);

    private Bindables() {
    }

    private static Enumerable<Object[]> help(DataContext dataContext, BindableRel rel) {
        return new Interpreter(dataContext, rel);
    }

    private static class BindableWindowRule
    extends ConverterRule {
        BindableWindowRule() {
            super(LogicalWindow.class, Convention.NONE, BindableConvention.INSTANCE, "BindableWindowRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalWindow winAgg = (LogicalWindow)rel;
            RelTraitSet traitSet = winAgg.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode child = winAgg.getInput();
            RelNode convertedChild = BindableWindowRule.convert(child, child.getTraitSet().replace(BindableConvention.INSTANCE));
            return new BindableWindow(rel.getCluster(), traitSet, convertedChild, winAgg.getConstants(), winAgg.getRowType(), (List<Window.Group>)winAgg.groups);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableWindow
    extends Window
    implements BindableRel {
        BindableWindow(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
            super(cluster, traits, child, constants, rowType, groups);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new BindableWindow(this.getCluster(), traitSet, BindableWindow.sole(inputs), this.constants, this.rowType, (List<Window.Group>)this.groups);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return super.computeSelfCost(planner).multiplyBy(2.0);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new WindowNode(implementor.interpreter, this);
        }
    }

    private static class BindableAggregateRule
    extends ConverterRule {
        BindableAggregateRule() {
            super(LogicalAggregate.class, Convention.NONE, BindableConvention.INSTANCE, "BindableAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace(BindableConvention.INSTANCE);
            try {
                return new BindableAggregate(rel.getCluster(), traitSet, BindableAggregateRule.convert(agg.getInput(), traitSet), agg.indicator, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                RelOptPlanner.LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableAggregate
    extends Aggregate
    implements BindableRel {
        public BindableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, child, indicator, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof BindableConvention);
            for (AggregateCall aggCall : aggCalls) {
                if (aggCall.isDistinct()) {
                    throw new InvalidRelException("distinct aggregation not supported");
                }
                AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
                if (implementor2 != null) continue;
                throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
            }
        }

        @Override
        public BindableAggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new BindableAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new AggregateNode(implementor.interpreter, this);
        }
    }

    private static class BindableValuesRule
    extends ConverterRule {
        BindableValuesRule() {
            super(LogicalValues.class, Convention.NONE, BindableConvention.INSTANCE, "BindableValuesRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalValues values = (LogicalValues)rel;
            return new BindableValues(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet().replace(BindableConvention.INSTANCE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableValues
    extends Values
    implements BindableRel {
        BindableValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new BindableValues(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples, traitSet);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new ValuesNode(implementor.interpreter, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableUnion
    extends Union
    implements BindableRel {
        public BindableUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public BindableUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new BindableUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new UnionNode(implementor.interpreter, this);
        }
    }

    private static class BindableUnionRule
    extends ConverterRule {
        BindableUnionRule() {
            super(LogicalUnion.class, Convention.NONE, BindableConvention.INSTANCE, "BindableUnionRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalUnion union = (LogicalUnion)rel;
            BindableConvention out = BindableConvention.INSTANCE;
            RelTraitSet traitSet = union.getTraitSet().replace(out);
            return new BindableUnion(rel.getCluster(), traitSet, BindableUnionRule.convertList(union.getInputs(), out), union.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableJoin
    extends Join
    implements BindableRel {
        protected BindableJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
            super(cluster, traits, left, right, condition, joinType, variablesStopped);
        }

        @Override
        public BindableJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            return new BindableJoin(this.getCluster(), traitSet, left, right, conditionExpr, joinType, (Set<String>)this.variablesStopped);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new JoinNode(implementor.interpreter, this);
        }
    }

    private static class BindableJoinRule
    extends ConverterRule {
        BindableJoinRule() {
            super(LogicalJoin.class, Convention.NONE, BindableConvention.INSTANCE, "BindableJoinRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            BindableConvention out = BindableConvention.INSTANCE;
            RelTraitSet traitSet = join.getTraitSet().replace(out);
            return new BindableJoin(rel.getCluster(), traitSet, BindableJoinRule.convert(join.getLeft(), join.getLeft().getTraitSet().replace(BindableConvention.INSTANCE)), BindableJoinRule.convert(join.getRight(), join.getRight().getTraitSet().replace(BindableConvention.INSTANCE)), join.getCondition(), join.getJoinType(), join.getVariablesStopped());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableSort
    extends Sort
    implements BindableRel {
        public BindableSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, child, collation, offset, fetch);
            assert (this.getConvention() instanceof BindableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        @Override
        public BindableSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new BindableSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new SortNode(implementor.interpreter, this);
        }
    }

    private static class BindableSortRule
    extends ConverterRule {
        BindableSortRule() {
            super(Sort.class, Convention.NONE, BindableConvention.INSTANCE, "BindableSortRule");
        }

        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode input = sort.getInput();
            return new BindableSort(rel.getCluster(), traitSet, BindableSortRule.convert(input, input.getTraitSet().replace(BindableConvention.INSTANCE)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableProject
    extends Project
    implements BindableRel {
        public BindableProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<? extends RexNode> exps, RelDataType rowType, int flags) {
            super(cluster, traitSet, child, exps, rowType, flags);
            assert (this.getConvention() instanceof BindableConvention);
        }

        @Override
        public BindableProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
            return new BindableProject(this.getCluster(), traitSet, input, exps, rowType, this.flags);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new ProjectNode(implementor.interpreter, this);
        }
    }

    private static class BindableProjectRule
    extends ConverterRule {
        BindableProjectRule() {
            super(LogicalProject.class, RelOptUtil.PROJECT_PREDICATE, Convention.NONE, BindableConvention.INSTANCE, "BindableProjectRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new BindableProject(rel.getCluster(), rel.getTraitSet().replace(BindableConvention.INSTANCE), BindableProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(BindableConvention.INSTANCE)), project.getProjects(), project.getRowType(), 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableFilter
    extends Filter
    implements BindableRel {
        public BindableFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
            super(cluster, traitSet, child, condition);
            assert (this.getConvention() instanceof BindableConvention);
        }

        @Override
        public BindableFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new BindableFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new FilterNode(implementor.interpreter, this);
        }
    }

    private static class BindableFilterRule
    extends ConverterRule {
        private BindableFilterRule() {
            super(LogicalFilter.class, RelOptUtil.FILTER_PREDICATE, Convention.NONE, BindableConvention.INSTANCE, "BindableFilterRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return new BindableFilter(rel.getCluster(), rel.getTraitSet().replace(BindableConvention.INSTANCE), BindableFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(BindableConvention.INSTANCE)), filter.getCondition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindableTableScan
    extends TableScan
    implements BindableRel {
        BindableTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable table) {
            super(cluster, traits, table);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return this.table.unwrap(ScannableTable.class).scan(dataContext);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            throw new UnsupportedOperationException();
        }
    }

    private static class BindableTableScanRule
    extends RelOptRule {
        public BindableTableScanRule() {
            super(BindableTableScanRule.operand(TableScan.class, BindableTableScanRule.none()));
        }

        public void onMatch(RelOptRuleCall call) {
            TableScan scan = (TableScan)call.rel(0);
            call.transformTo(new BindableTableScan(scan.getCluster(), scan.getTraitSet().replace(BindableConvention.INSTANCE), scan.getTable()));
        }
    }
}

