/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.interpreter.Source;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rex.RexNode;

public class JoinNode
implements Node {
    private final Source leftSource;
    private final Source rightSource;
    private final Sink sink;
    private final Join rel;
    private final Scalar condition;
    private final Context context;

    public JoinNode(Interpreter interpreter, Join rel) {
        this.leftSource = interpreter.source(rel, 0);
        this.rightSource = interpreter.source(rel, 1);
        this.sink = interpreter.sink(rel);
        this.condition = interpreter.compile((List<RexNode>)ImmutableList.of((Object)rel.getCondition()), rel.getInputs());
        this.rel = rel;
        this.context = interpreter.createContext();
    }

    public void run() throws InterruptedException {
        Row left;
        ArrayList rightList = null;
        int leftCount = this.rel.getLeft().getRowType().getFieldCount();
        int rightCount = this.rel.getRight().getRowType().getFieldCount();
        this.context.values = new Object[this.rel.getRowType().getFieldCount()];
        while ((left = this.leftSource.receive()) != null) {
            System.arraycopy(left.getValues(), 0, this.context.values, 0, leftCount);
            if (rightList == null) {
                Row right;
                rightList = Lists.newArrayList();
                while ((right = this.rightSource.receive()) != null) {
                    rightList.add(right);
                }
            }
            for (Row right2 : rightList) {
                System.arraycopy(right2.getValues(), 0, this.context.values, leftCount, rightCount);
                Boolean execute = (Boolean)this.condition.execute(this.context);
                if (execute == null || !execute.booleanValue()) continue;
                this.sink.send(Row.asCopy(this.context.values));
            }
        }
    }
}

