/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelOptTableImpl
implements Prepare.PreparingTable {
    private final RelOptSchema schema;
    private final RelDataType rowType;
    private final Table table;
    private final Function<Class, Expression> expressionFunction;
    private final ImmutableList<String> names;
    private final Double rowCount;

    private RelOptTableImpl(RelOptSchema schema, RelDataType rowType, List<String> names, Table table, Function<Class, Expression> expressionFunction, Double rowCount) {
        this.schema = schema;
        this.rowType = rowType;
        this.names = ImmutableList.copyOf(names);
        this.table = table;
        this.expressionFunction = expressionFunction;
        this.rowCount = rowCount;
        assert (expressionFunction != null);
        assert (rowType != null);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, List<String> names, Expression expression) {
        Function expressionFunction = Functions.constant((Object)expression);
        return new RelOptTableImpl(schema, rowType, names, null, (Function<Class, Expression>)expressionFunction, null);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, final CalciteSchema.TableEntry tableEntry, Double rowCount) {
        Object expressionFunction;
        final Table table = tableEntry.getTable();
        if (table instanceof QueryableTable) {
            final QueryableTable queryableTable = (QueryableTable)table;
            expressionFunction = new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return queryableTable.getExpression(tableEntry.schema.plus(), tableEntry.name, clazz);
                }
            };
        } else {
            expressionFunction = table instanceof ScannableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable ? new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return Schemas.tableExpression(tableEntry.schema.plus(), Object[].class, tableEntry.name, table.getClass());
                }
            } : new Function<Class, Expression>(){

                public Expression apply(Class input) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new RelOptTableImpl(schema, rowType, tableEntry.path(), table, (Function<Class, Expression>)expressionFunction, rowCount);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, TranslatableTable table) {
        Function<Class, Expression> expressionFunction = new Function<Class, Expression>(){

            public Expression apply(Class input) {
                throw new UnsupportedOperationException();
            }
        };
        return new RelOptTableImpl(schema, rowType, (List<String>)ImmutableList.of(), table, expressionFunction, null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isInstance(this.table)) {
            return clazz.cast(this.table);
        }
        if (clazz == CalciteSchema.class) {
            return clazz.cast(Schemas.subSchema(((CalciteCatalogReader)this.schema).rootSchema, Util.skipLast(this.getQualifiedName())));
        }
        return null;
    }

    @Override
    public Expression getExpression(Class clazz) {
        return (Expression)this.expressionFunction.apply((Object)clazz);
    }

    @Override
    public RelOptTable extend(List<RelDataTypeField> extendedFields) {
        if (this.table instanceof ExtensibleTable) {
            Table extendedTable = ((ExtensibleTable)this.table).extend(extendedFields);
            RelDataType extendedRowType = extendedTable.getRowType(this.schema.getTypeFactory());
            return new RelOptTableImpl(this.schema, extendedRowType, (List<String>)this.names, extendedTable, this.expressionFunction, this.rowCount);
        }
        throw new RuntimeException("Cannot extend " + this.table);
    }

    @Override
    public double getRowCount() {
        Double rowCount;
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (this.table != null && (rowCount = this.table.getStatistic().getRowCount()) != null) {
            return rowCount;
        }
        return 100.0;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        if (this.table instanceof TranslatableTable) {
            return ((TranslatableTable)this.table).toRel(context, this);
        }
        RelOptCluster cluster = context.getCluster();
        Class elementType = this.deduceElementType();
        EnumerableTableScan scan = new EnumerableTableScan(cluster, cluster.traitSetOf(EnumerableConvention.INSTANCE), this, elementType);
        if (this.table instanceof FilterableTable || this.table instanceof ProjectableFilterableTable) {
            return new EnumerableInterpreter(cluster, scan.getTraitSet(), scan, 1.0);
        }
        return scan;
    }

    private Class deduceElementType() {
        if (this.table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)this.table;
            Type type = queryableTable.getElementType();
            if (type instanceof Class) {
                return (Class)type;
            }
            return Object[].class;
        }
        if (this.table instanceof ScannableTable || this.table instanceof FilterableTable || this.table instanceof ProjectableFilterableTable) {
            return Object[].class;
        }
        return Object.class;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.emptyList();
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        return this.table.getStatistic().isKey(columns);
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.names;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }
}

