/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationId
implements Cloneable,
Comparable<CorrelationId> {
    private static final String CORREL_PREFIX = "$cor";
    private final int id;
    private final String name;

    public CorrelationId(int id) {
        this.id = id;
        this.name = CORREL_PREFIX + id;
    }

    public CorrelationId(String name) {
        assert (name != null && name.startsWith(CORREL_PREFIX)) : "Correlation name should start with $cor actual name is " + name;
        this.id = Integer.parseInt(name.substring(CORREL_PREFIX.length()));
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CorrelationId other) {
        return this.id - other.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CorrelationId && this.id == ((CorrelationId)obj).id;
    }
}

