/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Intersect
extends SetOp {
    public Intersect(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, SqlKind.INTERSECT, all);
    }

    protected Intersect(RelInput input) {
        super(input);
    }

    @Override
    public double getRows() {
        double dRows = Double.MAX_VALUE;
        for (RelNode input : this.inputs) {
            dRows = Math.min(dRows, RelMetadataQuery.getRowCount(input));
        }
        return dRows *= 0.25;
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        for (RelNode input : this.inputs) {
            if (!input.isKey(columns)) continue;
            return true;
        }
        return super.isKey(columns);
    }
}

