/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.EnumSet;
import org.apache.calcite.sql.SqlAccessEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAccessType {
    public static final SqlAccessType ALL = new SqlAccessType(EnumSet.allOf(SqlAccessEnum.class));
    public static final SqlAccessType READ_ONLY = new SqlAccessType(EnumSet.of(SqlAccessEnum.SELECT));
    public static final SqlAccessType WRITE_ONLY = new SqlAccessType(EnumSet.of(SqlAccessEnum.INSERT));
    private final EnumSet<SqlAccessEnum> accessEnums;

    public SqlAccessType(EnumSet<SqlAccessEnum> accessEnums) {
        this.accessEnums = accessEnums;
    }

    public boolean allowsAccess(SqlAccessEnum access) {
        return this.accessEnums.contains((Object)access);
    }

    public String toString() {
        return this.accessEnums.toString();
    }

    public static SqlAccessType create(String[] accessNames) {
        assert (accessNames != null);
        EnumSet<SqlAccessEnum> enumSet = EnumSet.noneOf(SqlAccessEnum.class);
        for (int i = 0; i < accessNames.length; ++i) {
            enumSet.add(SqlAccessEnum.valueOf(accessNames[i].trim().toUpperCase()));
        }
        return new SqlAccessType(enumSet);
    }

    public static SqlAccessType create(String accessString) {
        assert (accessString != null);
        accessString = accessString.replace('[', ' ');
        accessString = accessString.replace(']', ' ');
        String[] accessNames = accessString.split(",");
        return SqlAccessType.create(accessNames);
    }
}

