/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDynamicParam
extends SqlNode {
    private final int index;

    public SqlDynamicParam(int index, SqlParserPos pos) {
        super(pos);
        this.index = index;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlDynamicParam(this.index, pos);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DYNAMIC_PARAM;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.print("?");
        writer.setNeedWhitespace(false);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDynamicParam(this);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (!(node instanceof SqlDynamicParam)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlDynamicParam that = (SqlDynamicParam)node;
        if (this.index != that.index) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return true;
    }
}

